/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template.metamodel;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import javax.tools.FileObject;
import juzu.impl.common.MethodInvocation;
import juzu.impl.common.Path;
import juzu.impl.common.Resource;
import juzu.impl.common.Timestamped;
import juzu.impl.common.Tools;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.plugin.template.metamodel.AbstractContainerMetaModel;
import juzu.impl.plugin.template.metamodel.Template;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;
import juzu.impl.template.spi.ParseContext;
import juzu.impl.template.spi.ProcessContext;
import juzu.impl.template.spi.TemplateException;
import juzu.impl.template.spi.TemplateModel;
import juzu.impl.template.spi.TemplateProvider;
import juzu.template.TagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetaModelProcessContext
extends ProcessContext {
    private AbstractContainerMetaModel owner;
    private final ProcessingContext env;
    private final TemplateMetaModel metaModel;

    MetaModelProcessContext(AbstractContainerMetaModel owner, TemplateMetaModel metaModel) {
        this.owner = owner;
        this.env = owner.application.getProcessingContext();
        this.metaModel = metaModel;
    }

    void resolve(TemplateMetaModel metaModel) throws TemplateException {
        this.resolveTemplate(metaModel.path);
    }

    @Override
    public TagHandler resolveTagHandler(String name) {
        return this.owner.resolveTagHandler(name);
    }

    @Override
    protected Path.Absolute resolvePath(Path.Relative path) {
        return this.owner.resolvePath(path);
    }

    @Override
    public MethodInvocation resolveMethodInvocation(String typeName, String methodName, Map<String, String> parameterMap) throws ProcessingException {
        return this.owner.getApplication().resolveMethodInvocation(typeName, methodName, parameterMap);
    }

    @Override
    public Timestamped<Resource> resolveResource(Path.Absolute path) {
        FileObject resource = this.owner.application.resolveResource(path);
        if (resource != null) {
            try {
                byte[] bytes = Tools.bytes(resource.openInputStream());
                long lastModified = resource.getLastModified();
                return new Timestamped<Resource>(lastModified, new Resource(bytes, Charset.defaultCharset()));
            }
            catch (Exception e) {
                this.env.info("Could not get resource content " + path.getCanonical(), e);
            }
        }
        return null;
    }

    @Override
    public Path.Absolute resolveTemplate(Path path) throws TemplateException {
        Path.Absolute absolute = path instanceof Path.Relative ? this.resolvePath((Path.Relative)path) : (Path.Absolute)path;
        return this.resolveTemplate(absolute);
    }

    private <M extends Serializable> Path.Absolute resolveTemplate(Path.Absolute path) throws TemplateException {
        Template template = path.equals(this.metaModel.path) ? this.metaModel : this.owner.add(path, Collections.singletonList(this.metaModel));
        if (template instanceof TemplateMetaModel) {
            TemplateMetaModel tmm = template;
            if (tmm.templateModel == null) {
                Object templateAST;
                Timestamped<Resource> resource = this.resolveResource(path);
                if (resource == null) {
                    throw TemplateMetaModel.TEMPLATE_NOT_RESOLVED.failure(path);
                }
                TemplateProvider<?> provider = this.owner.resolveTemplateProvider(path.getExt());
                try {
                    templateAST = provider.parse(new ParseContext(), resource.getObject().getCharSequence());
                }
                catch (TemplateException e1) {
                    throw TemplateMetaModel.TEMPLATE_SYNTAX_ERROR.failure(path).initCause(e1);
                }
                TemplateModel templateModel = new TemplateModel(templateAST, path, resource.getTime(), Tools.md5(resource.getObject().getBytes()));
                tmm.templateModel = templateModel;
                try {
                    provider.process(new MetaModelProcessContext(this.owner, tmm), templateModel);
                }
                catch (TemplateException e) {
                    throw TemplateMetaModel.TEMPLATE_VALIDATION_ERROR.failure(path);
                }
            }
        }
        return path;
    }
}

