/*
 * Decompiled with CFR 0.152.
 */
package juzu.template;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.impl.common.Tools;
import juzu.impl.template.spi.TemplateStub;
import juzu.impl.template.spi.juzu.dialect.gtmpl.MessageKey;
import juzu.io.OutputStream;
import juzu.io.Stream;
import juzu.template.Renderable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateRenderContext {
    private Map<String, Object> attributes;
    private final Locale locale;
    private PropertyMap properties;
    protected Stream printer;
    private final TemplateStub stub;

    public TemplateRenderContext(TemplateStub stub) {
        this(stub, (Map<String, Object>)null);
    }

    public TemplateRenderContext(TemplateStub stub, Map<String, Object> attributes) {
        this(stub, null, attributes, null);
    }

    public TemplateRenderContext(TemplateStub stub, Locale locale) {
        this(stub, null, null, locale);
    }

    public TemplateRenderContext(TemplateStub stub, PropertyMap properties, Map<String, Object> attributes, Locale locale) {
        this.locale = locale;
        this.attributes = attributes;
        this.stub = stub;
        this.properties = properties;
    }

    public void renderTag(String name, Renderable body, Map<String, String> parameters) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Map<String, ?> getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException("No null attribute name accepted");
        }
        return this.attributes != null ? this.attributes.get(name) : null;
    }

    public Object setAttribute(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("No null attribute name accepted");
        }
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            return this.attributes.put(name, value);
        }
        if (this.attributes != null) {
            return this.attributes.remove(name);
        }
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Stream getPrinter() {
        return this.printer;
    }

    public void setTitle(String title) {
        if (this.properties != null) {
            this.properties.setValue(PropertyType.TITLE, title);
        }
    }

    public TemplateStub resolveTemplate(String path) {
        return null;
    }

    public Object resolveBean(String expression) throws InvocationTargetException {
        return null;
    }

    public String resolveMessage(MessageKey key) {
        return key.toString();
    }

    public StringBuilder render() throws IOException {
        StringBuilder buffer = new StringBuilder();
        OutputStream consumer = OutputStream.create(Tools.UTF_8, buffer);
        this.render(consumer);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Stream printer) throws IOException {
        if (this.printer != null) {
            throw new IllegalStateException("Already rendering");
        }
        this.printer = printer;
        try {
            this.stub.render(this);
        }
        finally {
            this.printer = null;
        }
    }
}

