/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.servlet;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import juzu.impl.asset.AssetServer;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.bridge.module.ApplicationBridge;
import juzu.impl.bridge.module.ModuleContextImpl;
import juzu.impl.bridge.provided.ProvidedBridge;
import juzu.impl.bridge.spi.servlet.AbstractBridgeContext;
import juzu.impl.bridge.spi.servlet.ServletApplicationContext;
import juzu.impl.bridge.spi.servlet.ServletRequestContext;
import juzu.impl.bridge.spi.servlet.ServletWebBridge;
import juzu.impl.bridge.spi.web.Handler;
import juzu.impl.common.Completion;
import juzu.impl.common.JUL;
import juzu.impl.common.Logger;
import juzu.impl.common.SimpleMap;
import juzu.impl.common.Tools;
import juzu.impl.compiler.CompilationException;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.war.WarFileSystem;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.inject.spi.spring.SpringInjector;
import juzu.impl.resource.ResourceResolver;

public class ServletBridge
extends HttpServlet {
    public static final String BUNDLE_NAME = "juzu.resource_bundle";
    private String path;
    private BridgeConfig config;
    private Bridge bridge;
    private Handler handler;
    private String bundleName;
    private Logger servletLogger;
    ServletApplicationContext applicationContext;

    Bridge getBridge() {
        return this.bridge;
    }

    public void init() throws ServletException {
        BridgeConfig config;
        String path = null;
        ServletRegistration reg = this.getServletContext().getServletRegistration(this.getServletName());
        for (String mapping : reg.getMappings()) {
            if ("/".equals(mapping)) {
                path = "";
                break;
            }
            if ("/*".equals(mapping)) {
                throw new UnsupportedOperationException("Implement me");
            }
            if (mapping.endsWith("/*")) {
                path = mapping.substring(0, mapping.length() - 2);
                continue;
            }
            throw new UnsupportedOperationException("Should not be possible");
        }
        if (path == null) {
            throw new ServletException("Juzu servlet should be mounted on an url pattern");
        }
        Logger servletLogger = JUL.getLogger(ServletBridge.class + "." + this.getServletConfig().getServletName());
        final ServletConfig servletConfig = this.getServletConfig();
        try {
            config = new BridgeConfig(servletLogger, (Map<String, String>)new SimpleMap<String, String>(){

                @Override
                protected Iterator<String> keys() {
                    return BridgeConfig.NAMES.iterator();
                }

                @Override
                public String get(Object key) {
                    if ("juzu.app_name".equals(key)) {
                        return ServletBridge.this.getApplicationName(servletConfig);
                    }
                    if ("juzu.inject".equals(key)) {
                        String inject = servletConfig.getInitParameter((String)key);
                        if (inject == null) {
                            inject = servletConfig.getServletContext().getInitParameter((String)key);
                        }
                        return inject;
                    }
                    if ("juzu.request_encoding".equals(key)) {
                        return servletConfig.getServletContext().getInitParameter((String)key);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw ServletBridge.wrap(e);
        }
        if (config.name == null) {
            throw new ServletException("No application configured");
        }
        InjectorProvider injectorProvider = config.injectorProvider;
        if (injectorProvider == null) {
            throw new UnavailableException("No inject implementation selected");
        }
        servletLogger.info("Using inject implementation " + injectorProvider.getValue());
        this.config = config;
        this.handler = null;
        this.path = path;
        this.bundleName = servletConfig.getInitParameter(BUNDLE_NAME);
        this.servletLogger = servletLogger;
    }

    static ServletException wrap(Throwable e) {
        return e instanceof ServletException ? (ServletException)e : new ServletException("Could not find an application to start", e);
    }

    protected String getApplicationName(ServletConfig config) {
        return config.getInitParameter("juzu.app_name");
    }

    private void refresh() throws Exception {
        Completion<Boolean> refresh;
        if (this.bridge == null) {
            ModuleContextImpl module;
            AssetServer server = (AssetServer)this.getServletContext().getAttribute("asset.server");
            if (server == null) {
                server = new AssetServer();
                this.getServletContext().setAttribute("asset.server", (Object)server);
            }
            AbstractBridgeContext bridgeContext = new AbstractBridgeContext(){
                final ResourceResolver resolver = new ResourceResolver(){

                    public URL resolve(String uri) {
                        try {
                            return ServletBridge.this.getServletContext().getResource(uri);
                        }
                        catch (MalformedURLException e) {
                            return null;
                        }
                    }
                };

                @Override
                public ReadFileSystem<?> getResourcePath() {
                    return WarFileSystem.create(ServletBridge.this.getServletContext(), "/WEB-INF/");
                }

                @Override
                public ReadFileSystem<?> getClassPath() {
                    return WarFileSystem.create(ServletBridge.this.getServletContext(), "/WEB-INF/classes/");
                }

                @Override
                public ClassLoader getClassLoader() {
                    return ServletBridge.this.getServletContext().getClassLoader();
                }

                @Override
                public String getInitParameter(String name) {
                    return ServletBridge.this.getServletContext().getInitParameter(name);
                }

                @Override
                public ResourceResolver getResolver() {
                    return this.resolver;
                }

                @Override
                public Object getAttribute(String key) {
                    return ServletBridge.this.getServletContext().getAttribute(key);
                }

                @Override
                public void setAttribute(String key, Object value) {
                    ServletBridge.this.getServletContext().setAttribute(key, value);
                }
            };
            ResourceResolver resolver = new ResourceResolver(){

                public URL resolve(String uri) {
                    try {
                        return ServletBridge.this.getServletConfig().getServletContext().getResource(uri);
                    }
                    catch (MalformedURLException e) {
                        return null;
                    }
                }
            };
            Injector injector = this.config.injectorProvider.get();
            if (injector instanceof SpringInjector) {
                SpringInjector springInjector = (SpringInjector)injector;
                Object parent = this.getServletContext().getAttribute("org.springframework.web.context.WebApplicationContext.ROOT");
                if (parent != null) {
                    springInjector.setParent(parent);
                }
            }
            if ((module = (ModuleContextImpl)this.getServletContext().getAttribute("juzu.module")) == null) {
                module = new ModuleContextImpl(this.servletLogger, bridgeContext, resolver);
                this.getServletContext().setAttribute("juzu.module", (Object)module);
            }
            this.bridge = injector.isProvided() ? new ProvidedBridge(bridgeContext, this.config, server, resolver, injector) : new ApplicationBridge(module, bridgeContext, this.config, server, resolver, injector);
        }
        if ((refresh = this.bridge.refresh()).isFailed()) {
            throw refresh.getCause();
        }
        if (refresh.get().booleanValue() && this.handler != null) {
            Tools.safeClose(this.handler);
            this.handler = null;
            this.applicationContext = null;
        }
        if (this.handler == null) {
            this.handler = new Handler(this.bridge);
            this.applicationContext = new ServletApplicationContext(this.getServletContext().getClassLoader(), this.bundleName);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        URL url;
        ServletRequestContext ctx = new ServletRequestContext(this.config.name, this.config.requestEncoding, req, resp, this.path);
        ServletWebBridge bridge = new ServletWebBridge(this, ctx);
        if (ctx.getRequestPath().length() > 1 && !ctx.getRequestPath().startsWith("/WEB-INF/") && (url = this.getServletContext().getResource(ctx.getRequestPath())) != null) {
            RequestDispatcher dispatcher = this.getServletContext().getNamedDispatcher("default");
            dispatcher.include((ServletRequest)bridge.getRequestContext().req, (ServletResponse)bridge.getResponse());
            return;
        }
        try {
            this.refresh();
        }
        catch (CompilationException e) {
            ctx.send(e);
            return;
        }
        catch (Exception e) {
            throw ServletBridge.wrap(e);
        }
        try {
            this.handler.handle(bridge);
        }
        catch (Throwable throwable) {
            throw ServletBridge.wrap(throwable);
        }
    }

    public void destroy() {
        if (this.handler != null) {
            Tools.safeClose(this.handler);
            this.handler = null;
        }
    }
}

