/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.spring;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import juzu.Scope;
import juzu.impl.common.Filter;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.inject.ScopeController;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.spring.AbstractBean;
import juzu.impl.inject.spi.spring.DeclaredBean;
import juzu.impl.inject.spi.spring.DeclaredProviderBean;
import juzu.impl.inject.spi.spring.ScopeMetadataResolverImpl;
import juzu.impl.inject.spi.spring.SingletonBean;
import juzu.impl.inject.spi.spring.SingletonInstantiationStrategy;
import juzu.impl.inject.spi.spring.SingletonProviderBean;
import juzu.impl.inject.spi.spring.SpringContext;
import juzu.impl.inject.spi.spring.SpringScope;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.CustomAutowireConfigurer;
import org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringInjector
extends Injector {
    private ClassLoader classLoader;
    private LinkedHashMap<String, AbstractBean> beans;
    final HashMap<String, Object> instances;
    private final LinkedHashSet<Scope> scopes;
    private URL configurationURL;
    private BeanFactory parent;
    final ScopeMetadataResolverImpl scopeResolver;
    final ScopeController scopeController;

    public SpringInjector() {
        this.classLoader = null;
        this.beans = new LinkedHashMap();
        this.instances = new HashMap();
        this.scopes = new LinkedHashSet();
        this.configurationURL = null;
        this.scopeResolver = new ScopeMetadataResolverImpl(this.scopes);
        this.scopeController = new ScopeController();
        this.parent = null;
    }

    private SpringInjector(SpringInjector that) {
        this.classLoader = that.classLoader;
        this.beans = new LinkedHashMap<String, AbstractBean>(that.beans);
        this.instances = new HashMap<String, Object>(that.instances);
        this.scopes = new LinkedHashSet<Scope>(that.scopes);
        this.configurationURL = that.configurationURL;
        this.scopeResolver = new ScopeMetadataResolverImpl(this.scopes);
        this.scopeController = new ScopeController();
        this.parent = that.parent;
    }

    public void setParent(Object parent) {
        this.parent = (BeanFactory)parent;
    }

    private Injector declareBean(AbstractBean bean) {
        this.beans.put(bean.name, bean);
        return this;
    }

    @Override
    public boolean isProvided() {
        return false;
    }

    @Override
    public <T> Injector declareBean(Class<T> type, Scope beanScope, Iterable<Annotation> qualifiers, Class<? extends T> implementationType) {
        if (implementationType == null) {
            implementationType = type;
        }
        return this.declareBean(new DeclaredBean(implementationType, beanScope, qualifiers));
    }

    @Override
    public <T> Injector bindBean(Class<T> type, Iterable<Annotation> qualifiers, T instance) {
        return this.declareBean(new SingletonBean(instance, qualifiers));
    }

    @Override
    public <T> Injector bindProvider(Class<T> beanType, Scope beanScope, Iterable<Annotation> beanQualifiers, Provider<? extends T> provider) {
        return this.declareBean(new SingletonProviderBean(beanType, beanScope, beanQualifiers, provider));
    }

    @Override
    public <T> Injector declareProvider(Class<T> type, Scope beanScope, Iterable<Annotation> qualifiers, Class<? extends Provider<T>> provider) {
        return this.declareBean(new DeclaredProviderBean(type, beanScope, qualifiers, provider));
    }

    @Override
    public <P> Injector addFileSystem(ReadFileSystem<P> fs) {
        return this;
    }

    @Override
    public Injector addScope(Scope scope) {
        this.scopes.add(scope);
        return this;
    }

    @Override
    public Injector setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public InjectionContext<?, ?> create(Filter<Class<?>, Boolean> filter) throws Exception {
        Object factory = this.parent != null ? new DefaultListableBeanFactory(this.parent) : (this.configurationURL != null ? new XmlBeanFactory((Resource)new UrlResource(this.configurationURL)) : new DefaultListableBeanFactory());
        factory.setBeanClassLoader(this.classLoader);
        factory.setInstantiationStrategy((InstantiationStrategy)new SingletonInstantiationStrategy((InstantiationStrategy)new CglibSubclassingInstantiationStrategy(), this.instances));
        for (Scope scope : this.scopes) {
            if (scope.isBuiltIn()) continue;
            factory.registerScope(scope.name().toLowerCase(), (org.springframework.beans.factory.config.Scope)new SpringScope((DefaultListableBeanFactory)factory, scope, this.scopeController));
        }
        for (Map.Entry entry : this.beans.entrySet()) {
            AbstractBean bean = (AbstractBean)entry.getValue();
            String name = (String)entry.getKey();
            bean.configure(name, this, (DefaultListableBeanFactory)factory);
        }
        AutowiredAnnotationBeanPostProcessor beanPostProcessor = new AutowiredAnnotationBeanPostProcessor();
        beanPostProcessor.setAutowiredAnnotationType(Inject.class);
        beanPostProcessor.setBeanFactory((BeanFactory)factory);
        factory.addBeanPostProcessor((BeanPostProcessor)beanPostProcessor);
        CommonAnnotationBeanPostProcessor commonAnnotationBeanPostProcessor = new CommonAnnotationBeanPostProcessor();
        factory.addBeanPostProcessor((BeanPostProcessor)commonAnnotationBeanPostProcessor);
        HashSet<Class<Named>> cqt = new HashSet<Class<Named>>();
        cqt.add(Named.class);
        CustomAutowireConfigurer configurer = new CustomAutowireConfigurer();
        configurer.setCustomQualifierTypes(cqt);
        QualifierAnnotationAutowireCandidateResolver customResolver = new QualifierAnnotationAutowireCandidateResolver();
        factory.setAutowireCandidateResolver((AutowireCandidateResolver)customResolver);
        configurer.postProcessBeanFactory((ConfigurableListableBeanFactory)factory);
        return new SpringContext(this.scopeController, (DefaultListableBeanFactory)factory, this.classLoader);
    }

    @Override
    public Injector get() {
        return new SpringInjector(this);
    }
}

