/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.charset.Charset;
import juzu.impl.common.Tools;
import juzu.impl.io.CharStream;

public class AppendableStream
extends CharStream {
    private final Appendable out;
    private final Flushable flushable;
    private final Closeable closeable;

    public AppendableStream(Charset charset, Appendable out) {
        super(charset);
        this.out = out;
        this.flushable = null;
        this.closeable = null;
    }

    public AppendableStream(Charset charset, Appendable out, Flushable flushable, Closeable closeable) {
        super(charset);
        this.out = out;
        this.flushable = flushable;
        this.closeable = closeable;
    }

    public void append(CharSequence csq) throws IOException {
        this.out.append(csq);
    }

    public void append(CharSequence csq, int start, int end) throws IOException {
        this.out.append(csq, start, end);
    }

    public void append(char c) throws IOException {
        this.out.append(c);
    }

    public void close() {
        Tools.safeClose(this.closeable);
    }

    public void flush() throws IOException {
        Tools.safeFlush(this.flushable);
    }
}

