/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.IOException;

public class CharBuffer
implements Appendable {
    private static final int INITIAL_SIZE = 16;
    private char[] chars;
    private int from;
    private int to;

    public CharBuffer() {
        this(16);
    }

    public CharBuffer(int length) {
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        this.chars = new char[length];
        this.from = 0;
        this.to = 0;
    }

    public int getLength() {
        return this.to - this.from;
    }

    public int getSize() {
        return this.chars.length;
    }

    public void readFrom(char[] src, int at, int len) throws NullPointerException, IllegalArgumentException, IndexOutOfBoundsException {
        if (src == null) {
            throw new NullPointerException("Buffer cannot be null");
        }
        if (at < 0) {
            throw new IndexOutOfBoundsException("Begin pointer cannot be negative: " + at);
        }
        if (len < 0) {
            throw new IllegalArgumentException("Length cannot be negative: " + len);
        }
        if (at + len > src.length) {
            throw new IndexOutOfBoundsException("End pointer cannot be greater than buffer: " + (at + len));
        }
        this.ensure(len);
        System.arraycopy(src, at, this.chars, this.to, len);
        this.to += len;
    }

    public int writeTo(char[] dst, int at, int len) throws NullPointerException, IllegalArgumentException, IndexOutOfBoundsException {
        if (dst == null) {
            throw new NullPointerException("Destination cannot be null");
        }
        if (at < 0) {
            throw new IndexOutOfBoundsException("Begin pointer cannot be negative: " + at);
        }
        if (len < 0) {
            throw new IllegalArgumentException("Length cannot be negative: " + len);
        }
        if (at + len > dst.length) {
            throw new IndexOutOfBoundsException("End pointer cannot be greater than buffer: " + (at + len));
        }
        int l = Math.min(this.to - this.from, len);
        System.arraycopy(this.chars, this.from, dst, at, l);
        this.from += l;
        return l;
    }

    public int writeTo(Appendable dst) throws NullPointerException, IOException {
        if (dst == null) {
            throw new NullPointerException("Destination cannot be null");
        }
        int from = this.from;
        int to = this.to;
        char[] chars = this.chars;
        int delta = to - from;
        if (delta > 0) {
            while (from < to) {
                dst.append(chars[from++]);
            }
            this.from = from;
            this.to = to;
            this.chars = chars;
        }
        return delta;
    }

    private void ensure(int amount) {
        int remaining = this.chars.length - this.to;
        if (remaining < amount) {
            char[] tmp = new char[this.chars.length * 2];
            System.arraycopy(this.chars, this.from, tmp, this.from, this.to - this.from);
            this.chars = tmp;
        }
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        if (start < 0) {
            throw new IndexOutOfBoundsException("Start " + start + " cannot be negative");
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("Start " + start + " cannot be greater then end " + end);
        }
        if (end > csq.length()) {
            throw new IndexOutOfBoundsException("End " + end + " cannot be greater then char sequence " + csq.length());
        }
        int len = end - start;
        this.ensure(len);
        while (start < end) {
            this.chars[this.to++] = csq.charAt(start++);
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.ensure(1);
        this.chars[this.to++] = c;
        return this;
    }
}

