/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;

public class Introspector {
    public static Class<?> resolveToClass(Type implementation, Class<?> type, int parameterIndex) {
        if (implementation == null) {
            throw new NullPointerException("No null type accepted");
        }
        Type resolvedType = Introspector.resolve(implementation, type, parameterIndex);
        if (resolvedType != null) {
            return Introspector.resolveToClass(resolvedType);
        }
        return null;
    }

    public static Class resolveToClass(Type type) {
        if (type == null) {
            throw new NullPointerException("No null type accepted");
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof TypeVariable) {
            TypeVariable resolvedTypeVariable = (TypeVariable)type;
            return Introspector.resolveToClass(resolvedTypeVariable.getBounds()[0]);
        }
        throw new UnsupportedOperationException("Type resolution of " + type + " not yet implemented");
    }

    public static Type resolve(Type implementation, Class<?> type, int parameterIndex) {
        if (implementation == null) {
            throw new NullPointerException();
        }
        if (implementation == type) {
            TypeVariable<Class<?>>[] tp = type.getTypeParameters();
            if (parameterIndex < tp.length) {
                return tp[parameterIndex];
            }
            throw new IllegalArgumentException();
        }
        if (implementation instanceof Class) {
            Class c = (Class)implementation;
            Type gsc = c.getGenericSuperclass();
            Type resolved = null;
            if (gsc == null || (resolved = Introspector.resolve(gsc, type, parameterIndex)) == null) {
                // empty if block
            }
            return resolved;
        }
        if (implementation instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)implementation;
            Type[] typeArgs = pt.getActualTypeArguments();
            Type rawType = pt.getRawType();
            if (rawType == type) {
                return typeArgs[parameterIndex];
            }
            if (rawType instanceof Class) {
                Class classRawType = (Class)rawType;
                Type resolved = Introspector.resolve(classRawType, type, parameterIndex);
                if (resolved == null) {
                    return null;
                }
                if (resolved instanceof TypeVariable) {
                    TypeVariable resolvedTV = (TypeVariable)resolved;
                    TypeVariable<Class<T>>[] a = classRawType.getTypeParameters();
                    for (int i = 0; i < a.length; ++i) {
                        if (!a[i].equals(resolvedTV)) continue;
                        return Introspector.resolve(implementation, classRawType, i);
                    }
                    throw new AssertionError();
                }
                throw new UnsupportedOperationException("Cannot support resolution of " + resolved);
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException("todo " + implementation + " " + implementation.getClass());
    }

    public static boolean instanceOf(Class c, List<String> types) {
        for (String type : types) {
            if (!Introspector.instanceOf(c, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean instanceOf(Class c, String type) {
        if (c.getName().equals(type)) {
            return true;
        }
        for (Class<?> i : c.getInterfaces()) {
            if (!Introspector.instanceOf(i, type)) continue;
            return true;
        }
        if (c.getSuperclass() != null) {
            return Introspector.instanceOf(c.getSuperclass(), type);
        }
        return false;
    }
}

