/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;

public class Resource {
    private byte[] data;
    private Charset encoding;

    public Resource(byte[] data, Charset encoding) {
        if (data == null) {
            throw new NullPointerException("No null data accepted");
        }
        this.data = data;
        this.encoding = encoding;
    }

    public Resource(CharSequence s) {
        this(s, Charset.defaultCharset());
    }

    public Resource(CharSequence s, Charset encoding) {
        this.encoding = encoding;
        this.data = ((Object)s).toString().getBytes(encoding);
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public byte[] getBytes() {
        return (byte[])this.data.clone();
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public CharSequence getCharSequence(Charset encoding) {
        return new String(this.data, encoding);
    }

    public CharSequence getCharSequence() {
        if (this.encoding == null) {
            throw new IllegalStateException("No encoding set");
        }
        return new String(this.data, this.encoding);
    }

    public int getSize() {
        return this.data.length;
    }
}

