/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import juzu.impl.common.Resource;
import juzu.impl.common.Tools;
import juzu.impl.fs.Filter;
import juzu.impl.fs.Snapshot;
import juzu.impl.fs.spi.ReadFileSystem;

public abstract class FileSystemScanner<P>
implements Filter<P> {
    protected final ReadFileSystem<P> fs;
    final ArrayList<String> stack = new ArrayList();

    public static <P> FileSystemScanner<P> createTimestamped(ReadFileSystem<P> fs) {
        return new Timestamped<P>(fs);
    }

    public static <P> FileSystemScanner<P> createHashing(ReadFileSystem<P> fs) {
        return new Hash<P>(fs);
    }

    private FileSystemScanner(ReadFileSystem<P> fs) {
        this.fs = fs;
    }

    public ReadFileSystem<P> getFileSystem() {
        return this.fs;
    }

    public Snapshot<P> take() {
        return new Snapshot(this);
    }

    @Override
    public boolean acceptDir(P dir, String name) throws IOException {
        return !name.startsWith(".");
    }

    @Override
    public boolean acceptFile(P file, String name) throws IOException {
        return !name.startsWith(".");
    }

    protected abstract long stampOf(P var1) throws IOException;

    protected abstract boolean isModified(long var1, long var3);

    public static class Hash<P>
    extends FileSystemScanner<P> {
        public Hash(ReadFileSystem<P> fs) {
            super(fs);
        }

        @Override
        protected long stampOf(P file) throws IOException {
            juzu.impl.common.Timestamped<Resource> resource = this.fs.getResource(file);
            InputStream in = resource.getObject().getInputStream();
            byte[] bytes = Tools.bytes(in);
            return Tools.md5(bytes);
        }

        @Override
        protected boolean isModified(long snapshot, long current) {
            return snapshot != current;
        }
    }

    public static class Timestamped<P>
    extends FileSystemScanner<P> {
        public Timestamped(ReadFileSystem<P> fs) {
            super(fs);
        }

        @Override
        protected long stampOf(P file) throws IOException {
            return this.fs.getLastModified(file);
        }

        @Override
        protected boolean isModified(long snapshot, long current) {
            return snapshot < current;
        }
    }
}

