/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi;

import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import juzu.impl.inject.ScopeController;
import juzu.impl.inject.spi.BeanLifeCycle;
import juzu.impl.inject.spi.InjectorProvider;

public abstract class InjectionContext<B, C>
implements Closeable {
    public abstract ScopeController getScopeController();

    public abstract InjectorProvider getProvider();

    public abstract ClassLoader getClassLoader();

    public abstract B resolveBean(Class<?> var1);

    public abstract B resolveBean(String var1);

    public abstract Iterable<B> resolveBeans(Class<?> var1);

    public abstract C createContext(B var1) throws InvocationTargetException;

    public abstract void releaseContext(B var1, C var2);

    public abstract Object getInstance(B var1, C var2) throws InvocationTargetException;

    @Override
    public abstract void close();

    public final <T> BeanLifeCycle<T> get(Class<T> type) {
        B a = this.resolveBean(type);
        if (a == null) {
            return null;
        }
        return new BeanLifeCycleImpl(type, this, a);
    }

    public final <T> Iterable<BeanLifeCycle<T>> resolve(final Class<T> type) {
        final Iterable<B> a = this.resolveBeans(type);
        return new Iterable<BeanLifeCycle<T>>(){

            @Override
            public Iterator<BeanLifeCycle<T>> iterator() {
                return new Iterator<BeanLifeCycle<T>>(){
                    final Iterator<B> i;
                    {
                        this.i = a.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public BeanLifeCycle<T> next() {
                        Object b = this.i.next();
                        return new BeanLifeCycleImpl(type, InjectionContext.this, b);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public final <T> T resolveInstance(Class<T> beanType) {
        try {
            BeanLifeCycle<T> pluginLifeCycle = this.get(beanType);
            return pluginLifeCycle != null ? (T)pluginLifeCycle.get() : null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public final <T> Iterable<T> resolveInstances(final Class<T> beanType) {
        return new Iterable<T>(){
            Iterable<BeanLifeCycle<T>> lifecycles;
            {
                this.lifecycles = InjectionContext.this.resolve(beanType);
            }

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<BeanLifeCycle<T>> iterator;
                    T next;
                    {
                        this.iterator = lifecycles.iterator();
                        this.next = null;
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.next == null && this.iterator.hasNext()) {
                            try {
                                BeanLifeCycle pluginLifeCycle = this.iterator.next();
                                this.next = pluginLifeCycle.get();
                            }
                            catch (InvocationTargetException invocationTargetException) {}
                        }
                        return this.next != null;
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Object tmp = this.next;
                        this.next = null;
                        return tmp;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static class BeanLifeCycleImpl<B, C, I>
    implements BeanLifeCycle<I> {
        final Class<I> type;
        final InjectionContext<B, C> manager;
        final B a;
        private C context;
        private I instance;

        private BeanLifeCycleImpl(Class<I> type, InjectionContext<B, C> manager, B a) {
            this.type = type;
            this.manager = manager;
            this.a = a;
        }

        @Override
        public I get() throws InvocationTargetException {
            if (this.instance == null) {
                this.context = this.manager.createContext(this.a);
                this.instance = this.type.cast(this.manager.getInstance(this.a, this.context));
            }
            return this.instance;
        }

        @Override
        public I peek() {
            return this.instance;
        }

        @Override
        public void close() {
            if (this.context != null) {
                this.manager.releaseContext(this.a, this.context);
            }
        }
    }
}

