/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.ajax;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import juzu.PropertyType;
import juzu.Response;
import juzu.asset.AssetLocation;
import juzu.impl.asset.AssetManager;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.PluginDescriptor;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.request.ControllerHandler;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.impl.request.Stage;
import juzu.io.Chunk;
import juzu.io.Stream;
import juzu.io.Streamable;
import juzu.plugin.ajax.Ajax;
import juzu.request.Phase;

public class AjaxPlugin
extends ApplicationPlugin
implements RequestFilter<Stage.Unmarshalling> {
    Map<String, ControllerHandler> table;
    @Inject
    ControllerPlugin controllerPlugin;
    @Inject
    AssetManager manager;

    public AjaxPlugin() {
        super("ajax");
    }

    @Override
    public PluginDescriptor init(PluginContext context) throws Exception {
        return context.getConfig() != null ? new PluginDescriptor() : null;
    }

    @PostConstruct
    public void start() throws Exception {
        URL url = AjaxPlugin.class.getClassLoader().getResource("juzu/impl/plugin/ajax/script.js");
        if (url == null) {
            throw new Exception("Not found script.js");
        }
        this.manager.createDeployment().addAsset("juzu.ajax", "script", AssetLocation.APPLICATION, "/juzu/impl/plugin/ajax/script.js", null, null, url, "jquery").deploy();
        HashMap<String, ControllerHandler> table = new HashMap<String, ControllerHandler>();
        for (ControllerHandler cm : this.controllerPlugin.getDescriptor().getHandlers()) {
            Ajax ajax = cm.getMethod().getAnnotation(Ajax.class);
            if (ajax == null) continue;
            table.put(cm.getName(), cm);
        }
        this.table = table;
    }

    @Override
    public Class<Stage.Unmarshalling> getStageType() {
        return Stage.Unmarshalling.class;
    }

    @Override
    public Response handle(Stage.Unmarshalling argument) {
        final Request request = argument.getRequest();
        Response result = argument.invoke();
        if (request.getPhase() == Phase.VIEW && result instanceof Response.Content) {
            Response.Status status = (Response.Status)result;
            final Streamable wrapped = status.streamable();
            Streamable wrapper = new Streamable(){

                @Override
                public void send(final Stream stream) throws IllegalStateException {
                    Stream our = new Stream(){
                        boolean done = false;

                        @Override
                        public void provide(Chunk chunk) {
                            if (chunk instanceof Chunk.Data && !this.done) {
                                this.done = true;
                                stream.provide(new Chunk.Property<String>("juzu.ajax", PropertyType.ASSET));
                                StringBuilder sb = new StringBuilder();
                                sb.append("<div class=\"jz\">\n");
                                for (Map.Entry<String, ControllerHandler> entry : AjaxPlugin.this.table.entrySet()) {
                                    String baseURL = ((Object)request.createDispatch(entry.getValue())).toString();
                                    sb.append("<div data-method-id=\"");
                                    sb.append(entry.getValue().getId());
                                    sb.append("\" data-url=\"");
                                    sb.append(baseURL);
                                    sb.append("\"/>");
                                    sb.append("</div>");
                                }
                                stream.provide(Chunk.create(sb));
                            }
                            stream.provide(chunk);
                        }

                        @Override
                        public void close(Thread.UncaughtExceptionHandler errorHandler) {
                            stream.provide(Chunk.create("</div>"));
                            stream.close(errorHandler);
                        }
                    };
                    wrapped.send(our);
                }
            };
            result = new Response.Content(status.getCode(), wrapper);
        }
        return result;
    }
}

