/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import juzu.impl.common.AbstractAnnotatedElement;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.request.ControlParameter;
import juzu.impl.value.ValueType;
import juzu.request.RequestParameter;

public class BeanParameter
extends ControlParameter {
    public BeanParameter(String name, Class<?> type) throws NullPointerException {
        super(name, type);
    }

    public BeanParameter(String name, AnnotatedElement annotations, Class<?> type) throws NullPointerException {
        super(name, annotations, type);
    }

    <T> T createMappedBean(ControllerPlugin plugin, boolean requiresPrefix, Class<T> clazz, String beanName, Map<String, RequestParameter> parameters) throws IllegalAccessException, InstantiationException {
        HashMap<String, String[]> beanParams = new HashMap<String, String[]>();
        String prefix = requiresPrefix ? beanName + "." : "";
        for (String key : parameters.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String paramName = key.substring(prefix.length());
            beanParams.put(paramName, parameters.get(key).toArray());
        }
        T bean = clazz.newInstance();
        for (String key : beanParams.keySet()) {
            String[] value = (String[])beanParams.get(key);
            String setterName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
            try {
                Field f;
                Object o;
                boolean success = this.callSetter(plugin, setterName, clazz, bean, value);
                if (success || (o = this.getValue(plugin, f = clazz.getField(key), f.getGenericType(), value)) == null) continue;
                f.set(bean, o);
            }
            catch (Exception e) {}
        }
        return bean;
    }

    Object getValue(ControllerPlugin plugin, AnnotatedElement annotated, Type type, String[] value) throws Exception {
        ValueType valueType;
        Type typeArg;
        ParameterizedType parameterizedType;
        if (type instanceof Class) {
            Class<?> clazz = (Class<?>)type;
            if (clazz.isArray()) {
                ValueType<?> valueType2 = plugin.resolveValueType(clazz = clazz.getComponentType());
                if (valueType2 != null) {
                    Object array = Array.newInstance(clazz, value.length);
                    for (int i = 0; i < value.length; ++i) {
                        Array.set(array, i, valueType2.parse(annotated, value[i]));
                    }
                    return array;
                }
            } else {
                ValueType<?> valueType3 = plugin.resolveValueType(clazz);
                if (valueType3 != null) {
                    return valueType3.parse(annotated, value[0]);
                }
            }
        } else if (type instanceof ParameterizedType && List.class.equals((Object)(parameterizedType = (ParameterizedType)type).getRawType()) && (typeArg = parameterizedType.getActualTypeArguments()[0]) instanceof Class && (valueType = plugin.resolveValueType((Class)typeArg)) != null) {
            ArrayList list = new ArrayList(value.length);
            for (String s : value) {
                list.add(valueType.parse(annotated, s));
            }
            return list;
        }
        return null;
    }

    <T> boolean callSetter(ControllerPlugin plugin, String methodName, Class<T> clazz, T target, String[] value) throws Exception {
        for (final Method m : clazz.getMethods()) {
            AbstractAnnotatedElement element;
            Object o;
            Type[] parameterTypes;
            int modifiers;
            if (!m.getName().equals(methodName) || !Modifier.isPublic(modifiers = m.getModifiers()) || Modifier.isStatic(modifiers) || (parameterTypes = m.getGenericParameterTypes()).length != 1 || (o = this.getValue(plugin, element = new AbstractAnnotatedElement(){

                @Override
                public Annotation[] getDeclaredAnnotations() {
                    return m.getParameterAnnotations()[0];
                }
            }, parameterTypes[0], value)) == null) continue;
            m.invoke(target, o);
            return true;
        }
        return false;
    }

    Map<String, String[]> buildBeanParameter(ControllerPlugin plugin, boolean requiresPrefix, String baseName, Object value) {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        try {
            Object v;
            for (Field field : value.getClass().getFields()) {
                if (!Modifier.isPublic(field.getModifiers()) || (v = field.get(value)) == null) continue;
                String name = requiresPrefix ? baseName + "." + field.getName() : field.getName();
                this.addParameter(plugin, parameters, name, field, field.getGenericType(), v);
            }
            for (AccessibleObject accessibleObject : value.getClass().getMethods()) {
                if (!Modifier.isPublic(((Method)accessibleObject).getModifiers()) || Modifier.isStatic(((Method)accessibleObject).getModifiers()) || !((Method)accessibleObject).getName().startsWith("get") || ((Method)accessibleObject).getName().length() <= 3 || ((Method)accessibleObject).getParameterTypes().length != 0 || (v = ((Method)accessibleObject).invoke(value, new Object[0])) == null) continue;
                String n = Character.toLowerCase(((Method)accessibleObject).getName().charAt(3)) + ((Method)accessibleObject).getName().substring(4);
                String name = requiresPrefix ? baseName + "." + n : n;
                this.addParameter(plugin, parameters, name, accessibleObject, ((Method)accessibleObject).getGenericReturnType(), v);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return parameters;
    }

    private void addParameter(ControllerPlugin plugin, Map<String, String[]> parameters, String name, AnnotatedElement annotated, Type type, Object value) {
        String[] v = this.getParameters(plugin, annotated, type, value);
        if (v != null) {
            parameters.put(name, v);
        }
    }

    private String[] getParameters(ControllerPlugin plugin, AnnotatedElement annotated, Type type, Object value) {
        ValueType valueType;
        Type typeArg;
        List list;
        int size;
        ParameterizedType parameterizedType;
        if (type instanceof Class) {
            Class<?> clazz = (Class<?>)type;
            if (clazz.isArray()) {
                ValueType<?> valueType2;
                clazz = clazz.getComponentType();
                int length = Array.getLength(value);
                if (length > 0 && (valueType2 = plugin.resolveValueType(clazz)) != null) {
                    String[] ret = new String[length];
                    for (int i = 0; i < length; ++i) {
                        Object element = Array.get(value, i);
                        ret[i] = valueType2.format(annotated, element);
                    }
                    return ret;
                }
            } else {
                ValueType<?> valueType3 = plugin.resolveValueType(clazz);
                if (valueType3 != null) {
                    return new String[]{valueType3.format(annotated, value)};
                }
            }
        } else if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType().equals(List.class) && (size = (list = (List)value).size()) > 0 && (typeArg = parameterizedType.getActualTypeArguments()[0]) instanceof Class && (valueType = plugin.resolveValueType((Class)typeArg)) != null) {
            String[] ret = new String[size];
            for (int i = 0; i < size; ++i) {
                Object element = list.get(i);
                ret[i] = valueType.format(annotated, element);
            }
            return ret;
        }
        return null;
    }
}

