/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.value;

import java.lang.reflect.AnnotatedElement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import juzu.Format;
import juzu.impl.common.Tools;

public abstract class ValueType<T> {
    public static ValueType<String> STRING = new ValueType<String>(){
        private final Iterable<Class<?>> TYPES = Collections.singleton(String.class);

        @Override
        public Iterable<Class<?>> getTypes() {
            return this.TYPES;
        }

        @Override
        public String parse(AnnotatedElement element, String s) {
            return s;
        }

        @Override
        public String format(AnnotatedElement element, String value) {
            return value;
        }
    };
    public static ValueType<Integer> INTEGER = new ValueType<Integer>(){
        private final Iterable<Class<?>> TYPES = Tools.safeUnmodifiableList(Integer.class, Integer.TYPE);

        @Override
        public Iterable<Class<?>> getTypes() {
            return this.TYPES;
        }

        @Override
        public Integer parse(AnnotatedElement element, String s) {
            return Integer.parseInt(s);
        }

        @Override
        public String format(AnnotatedElement element, Integer value) {
            return value.toString();
        }
    };
    public static ValueType<Byte> BYTE = new ValueType<Byte>(){
        private final Iterable<Class<?>> TYPES = Tools.safeUnmodifiableList(Byte.class, Byte.TYPE);

        @Override
        public Iterable<Class<?>> getTypes() {
            return this.TYPES;
        }

        @Override
        public Byte parse(AnnotatedElement element, String s) {
            return Byte.parseByte(s);
        }

        @Override
        public String format(AnnotatedElement element, Byte value) {
            return value.toString();
        }
    };
    public static ValueType<Long> LONG = new ValueType<Long>(){
        private final Iterable<Class<?>> TYPES = Tools.safeUnmodifiableList(Long.class, Long.TYPE);

        @Override
        public Iterable<Class<?>> getTypes() {
            return this.TYPES;
        }

        @Override
        public Long parse(AnnotatedElement element, String s) {
            return Long.parseLong(s);
        }

        @Override
        public String format(AnnotatedElement element, Long value) {
            return value.toString();
        }
    };
    public static ValueType<Short> SHORT = new ValueType<Short>(){
        private final Iterable<Class<?>> TYPES = Tools.safeUnmodifiableList(Short.class, Short.TYPE);

        @Override
        public Iterable<Class<?>> getTypes() {
            return this.TYPES;
        }

        @Override
        public Short parse(AnnotatedElement element, String s) {
            return Short.parseShort(s);
        }

        @Override
        public String format(AnnotatedElement element, Short value) {
            return value.toString();
        }
    };
    public static ValueType<Boolean> BOOLEAN = new ValueType<Boolean>(){
        private final Iterable<Class<?>> TYPES = Tools.safeUnmodifiableList(Boolean.class, Boolean.TYPE);

        @Override
        public Iterable<Class<?>> getTypes() {
            return this.TYPES;
        }

        @Override
        public Boolean parse(AnnotatedElement element, String s) {
            return Boolean.parseBoolean(s);
        }

        @Override
        public String format(AnnotatedElement element, Boolean value) {
            return value.toString();
        }
    };
    public static ValueType<Double> DOUBLE = new ValueType<Double>(){
        private final Iterable<Class<?>> TYPES = Tools.safeUnmodifiableList(Double.class, Double.TYPE);

        @Override
        public Iterable<Class<?>> getTypes() {
            return this.TYPES;
        }

        @Override
        public Double parse(AnnotatedElement element, String s) {
            return Double.parseDouble(s);
        }

        @Override
        public String format(AnnotatedElement element, Double value) {
            return value.toString();
        }
    };
    public static ValueType<Float> FLOAT = new ValueType<Float>(){
        private final Iterable<Class<?>> TYPES = Tools.safeUnmodifiableList(Float.class, Float.TYPE);

        @Override
        public Iterable<Class<?>> getTypes() {
            return this.TYPES;
        }

        @Override
        public Float parse(AnnotatedElement element, String s) {
            return Float.valueOf(Float.parseFloat(s));
        }

        @Override
        public String format(AnnotatedElement element, Float value) {
            return value.toString();
        }
    };
    public static ValueType<Date> DATE = new ValueType<Date>(){
        private final Iterable<Class<?>> TYPES = Tools.safeUnmodifiableList(Date.class);

        @Override
        public Iterable<Class<?>> getTypes() {
            return this.TYPES;
        }

        private SimpleDateFormat getSimpleDateFormat(AnnotatedElement element) {
            Format format = element.getAnnotation(Format.class);
            return format != null ? new SimpleDateFormat(format.value()) : new SimpleDateFormat();
        }

        @Override
        public Date parse(AnnotatedElement element, String s) throws ParseException {
            return this.getSimpleDateFormat(element).parse(s);
        }

        @Override
        public String format(AnnotatedElement element, Date value) {
            return this.getSimpleDateFormat(element).format(value);
        }
    };
    public static final List<ValueType<?>> DEFAULT = Tools.safeUnmodifiableList(STRING, INTEGER, LONG, BYTE, SHORT, FLOAT, DOUBLE, BOOLEAN, DATE);

    public abstract Iterable<Class<?>> getTypes();

    public abstract T parse(AnnotatedElement var1, String var2) throws Exception;

    public abstract String format(AnnotatedElement var1, T var2);
}

