/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import juzu.EventQueue;
import juzu.Response;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.portlet.PortletEventProducer;
import juzu.impl.bridge.spi.portlet.PortletRequestBridge;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.ControllerHandler;
import juzu.request.Phase;
import juzu.request.ResponseParameter;

public abstract class PortletInteractionBridge<Rq extends PortletRequest, Rs extends StateAwareResponse>
extends PortletRequestBridge<Rq, Rs> {
    protected PortletInteractionBridge(Bridge bridge, Phase phase, Rq req, Rs resp, PortletConfig config) {
        super(bridge, phase, req, resp, config);
    }

    protected PortletInteractionBridge(Bridge bridge, Phase phase, Rq req, Rs resp, PortletConfig config, ControllerHandler<?> target, Map<String, String[]> parameters) {
        super(bridge, phase, req, resp, config, target, parameters);
    }

    @Override
    public Map<ContextualParameter, Object> getContextualArguments(Set<ContextualParameter> parameters) {
        Map<ContextualParameter, Object> args = Collections.emptyMap();
        for (ContextualParameter parameter : parameters) {
            if (!EventQueue.class.isAssignableFrom(parameter.getType())) continue;
            PortletEventProducer producer = new PortletEventProducer();
            if (args.isEmpty()) {
                args = new HashMap<ContextualParameter, Object>();
            }
            args.put(parameter, producer);
        }
        return args;
    }

    @Override
    public void send() throws IOException, PortletException {
        if (this.response instanceof Response.View) {
            WindowState windowState;
            Response.View view = (Response.View)this.response;
            Phase.View.Dispatch update = (Phase.View.Dispatch)view;
            Map<String, ResponseParameter> parameters = update.getParameters();
            for (ResponseParameter entry : parameters.values()) {
                ((StateAwareResponse)this.resp).setRenderParameter(entry.getName(), entry.toArray());
            }
            ControllerHandler handler = this.bridge.getApplication().resolveBean(ControllerPlugin.class).getDescriptor().getMethodByHandle(update.getTarget());
            ((StateAwareResponse)this.resp).setRenderParameter("juzu.op", handler.getId());
            PortletMode portletMode = update.getProperties().getValue(JuzuPortlet.PORTLET_MODE);
            if (portletMode != null) {
                try {
                    ((StateAwareResponse)this.resp).setPortletMode(portletMode);
                }
                catch (PortletModeException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if ((windowState = update.getProperties().getValue(JuzuPortlet.WINDOW_STATE)) != null) {
                try {
                    ((StateAwareResponse)this.resp).setWindowState(windowState);
                }
                catch (WindowStateException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        } else if (this.response instanceof Response.Error) {
            Response.Error error = (Response.Error)this.response;
            throw new PortletException(error.getCause());
        }
    }
}

