/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import juzu.PropertyType;
import juzu.Response;
import juzu.asset.AssetLocation;
import juzu.impl.asset.Asset;
import juzu.impl.asset.AssetManager;
import juzu.impl.bridge.spi.web.AsyncStream;
import juzu.impl.bridge.spi.web.HttpStream;
import juzu.impl.common.Tools;
import juzu.io.Chunk;
import juzu.io.Stream;
import org.w3c.dom.Element;

public abstract class WebStream
implements AsyncStream {
    private static final int BUFFERING = 0;
    private static final int STREAMING = 1;
    private static final int CLOSED = 2;
    private static final int FAILED = 3;
    private final HttpStream stream;
    private int status = 0;
    private final AssetManager assetManager;
    private final Page page;
    private final boolean minifyAssets;

    public WebStream(HttpStream stream, AssetManager assetManager, boolean minifyAssets) {
        this.stream = stream;
        this.assetManager = assetManager;
        this.page = new Page();
        this.minifyAssets = minifyAssets;
    }

    @Override
    public void provide(Chunk chunk) {
        if (this.status == 0) {
            if (chunk instanceof Chunk.Property) {
                Chunk.Property property = (Chunk.Property)chunk;
                if (property.type == PropertyType.TITLE) {
                    this.page.title = (String)property.value;
                } else if (property.type == PropertyType.META_TAG) {
                    this.page.metaTags.add((Map.Entry)property.value);
                } else if (property.type == PropertyType.META_HTTP_EQUIV) {
                    this.page.metaHttpEquivs.add((Map.Entry)property.value);
                } else if (property.type == PropertyType.ASSET) {
                    this.page.assets.add((String)property.value);
                } else if (property.type == PropertyType.HEADER_TAG) {
                    this.page.headerTags.add((Element)property.value);
                } else {
                    this.stream.provide(property);
                }
            } else if (chunk instanceof Chunk.Data) {
                try {
                    if (this.page.assets.size() > 0 && this.assetManager != null) {
                        Iterable<Asset> resolvedAssets = this.assetManager.resolveAssets(this.page.assets);
                        Tools.addAll(this.page.resolvedAssets, resolvedAssets);
                    }
                    this.status = 1;
                    this.page.sendHeader(this.stream);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    this.status = 3;
                    this.stream.setStatusCode(500);
                    this.page.clear();
                    this.page.sendHeader(this.stream);
                    Response.error(e).asStatus(true).streamable().send(new Stream(){

                        @Override
                        public void provide(Chunk chunk) {
                            WebStream.this.stream.provide(chunk);
                        }

                        @Override
                        public void close(Thread.UncaughtExceptionHandler errorHandler) {
                        }
                    });
                    this.page.sendFooter(this.stream);
                    return;
                }
            }
        }
        if (this.status == 1) {
            this.stream.provide(chunk);
        }
    }

    public abstract String renderAssetURL(AssetLocation var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Thread.UncaughtExceptionHandler errorHandler) {
        if (this.status != 2) {
            try {
                if (this.status == 0) {
                    this.provide(Chunk.create(""));
                }
                if (this.status == 1) {
                    this.page.sendFooter(this.stream);
                }
            }
            finally {
                this.status = 2;
                this.stream.close(errorHandler);
            }
        }
    }

    @Override
    public void end() {
        this.stream.end();
    }

    private class Page {
        private String title = null;
        private final LinkedList<Map.Entry<String, String>> metaTags = new LinkedList();
        private final LinkedList<Map.Entry<String, String>> metaHttpEquivs = new LinkedList();
        private final LinkedList<String> assets = new LinkedList();
        private final LinkedList<String> scripts = new LinkedList();
        private final LinkedList<Element> headerTags = new LinkedList();
        private final LinkedList<Asset> resolvedAssets = new LinkedList();

        private Page() {
        }

        void clear() {
            this.title = null;
            this.metaTags.clear();
            this.assets.clear();
            this.headerTags.clear();
        }

        void sendHeader(HttpStream stream) {
            stream.provide(Chunk.create("<!DOCTYPE html>\n<html>\n<head>\n"));
            if (this.title != null) {
                stream.provide(Chunk.create("<title>\n"));
                stream.provide(Chunk.create(this.title));
                stream.provide(Chunk.create("</title>\n"));
            }
            if (stream.mimeType != null) {
                stream.provide(Chunk.create("<meta http-equiv=\"content-type\" content=\""));
                stream.provide(Chunk.create(stream.mimeType));
                stream.provide(Chunk.create("; charset="));
                stream.provide(Chunk.create(stream.encoding.name()));
                stream.provide(Chunk.create("\">\n"));
            }
            for (Map.Entry entry : this.metaHttpEquivs) {
                stream.provide(Chunk.create("<meta http-equiv=\""));
                stream.provide(Chunk.create((CharSequence)entry.getKey()));
                stream.provide(Chunk.create("\" content=\""));
                stream.provide(Chunk.create((CharSequence)entry.getValue()));
                stream.provide(Chunk.create("\">\n"));
            }
            for (Map.Entry entry : this.metaTags) {
                stream.provide(Chunk.create("<meta name=\""));
                stream.provide(Chunk.create((CharSequence)entry.getKey()));
                stream.provide(Chunk.create("\" content=\""));
                stream.provide(Chunk.create((CharSequence)entry.getValue()));
                stream.provide(Chunk.create("\">\n"));
            }
            for (Asset asset : this.resolvedAssets) {
                if (!asset.isStylesheet()) continue;
                String uri = asset.resolveURI(WebStream.this.minifyAssets);
                int pos = uri.lastIndexOf(46);
                String ext = pos == -1 ? "css" : uri.substring(pos + 1);
                String url = WebStream.this.renderAssetURL(asset.getLocation(), uri);
                stream.provide(Chunk.create("<link rel=\"stylesheet\" type=\"text/"));
                stream.provide(Chunk.create(ext));
                stream.provide(Chunk.create("\" href=\""));
                stream.provide(Chunk.create(url));
                stream.provide(Chunk.create("\"/>\n"));
            }
            List<Asset> modules = Collections.emptyList();
            for (Asset asset : this.resolvedAssets) {
                if (!asset.getType().equals("module")) continue;
                if (modules.isEmpty()) {
                    modules = new ArrayList<Asset>();
                }
                modules.add(asset);
            }
            if (!modules.isEmpty()) {
                this.renderAMD(modules, stream);
            }
            for (Asset asset : this.resolvedAssets) {
                if (!asset.isScript()) continue;
                String uri = asset.resolveURI(WebStream.this.minifyAssets);
                String url = WebStream.this.renderAssetURL(asset.getLocation(), uri);
                stream.provide(Chunk.create("<script type=\"text/javascript\" src=\""));
                stream.provide(Chunk.create(url));
                stream.provide(Chunk.create("\"></script>\n"));
            }
            for (Element headerTag : this.headerTags) {
                try {
                    StringBuilder buffer = new StringBuilder();
                    Tools.encodeHtml(headerTag, buffer);
                    stream.provide(Chunk.create(buffer));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            stream.provide(Chunk.create("</head>\n<body>\n"));
        }

        void sendFooter(Stream stream) {
            stream.provide(Chunk.create("</body>\n</html>\n"));
        }

        private void renderAMD(Iterable<Asset> modules, Stream stream) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("<script type=\"text/javascript\">");
            buffer.append(" var require={");
            buffer.append("\"paths\":{");
            Iterator<Asset> i = modules.iterator();
            while (i.hasNext()) {
                Asset module = i.next();
                buffer.append("\"").append(module.getId()).append("\":\"");
                String uri = module.resolveURI(WebStream.this.minifyAssets);
                uri = uri.substring(0, uri.lastIndexOf(".js"));
                buffer.append(WebStream.this.renderAssetURL(module.getLocation(), uri));
                buffer.append("\"");
                if (!i.hasNext()) continue;
                buffer.append(",");
            }
            buffer.append("}");
            buffer.append("};");
            buffer.append("</script>");
            stream.provide(Chunk.create(buffer));
        }
    }
}

