/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.composite;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import juzu.impl.common.Resource;
import juzu.impl.common.Timestamped;
import juzu.impl.fs.spi.PathType;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.composite.Context;

public class CompositeFileSystem
extends ReadFileSystem<Context> {
    private final Context root;
    final ReadFileSystem<?>[] compounds;

    public CompositeFileSystem(ReadFileSystem<?> ... compounds) {
        this.compounds = (ReadFileSystem[])compounds.clone();
        this.root = new Context(this);
    }

    @Override
    public Class<Context> getType() {
        return Context.class;
    }

    @Override
    public boolean equals(Context left, Context right) {
        return left == right;
    }

    @Override
    public Context getRoot() throws IOException {
        return this.root;
    }

    @Override
    public Context getChild(Context dir, String name) throws IOException {
        return (Context)dir.resolve().get(name);
    }

    @Override
    public Iterator<Context> getChildren(Context dir) throws IOException {
        return dir.resolve().getEntries();
    }

    @Override
    public long getLastModified(Context path) throws IOException {
        return 0L;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getName(Context path) {
        return (String)path.getKey();
    }

    @Override
    public Iterable<String> getNames(Context path) {
        return path.getPath();
    }

    @Override
    public PathType typeOf(Context path) throws IOException {
        for (int i = 0; i < path.paths.length; ++i) {
            PathType type;
            ReadFileSystem<?> compound = this.compounds[i];
            Object p = path.paths[i];
            if (p == null || (type = compound.typeOf(p)) == null) continue;
            return type;
        }
        return null;
    }

    @Override
    public Timestamped<Resource> getResource(Context file) throws IOException {
        for (int i = 0; i < file.paths.length; ++i) {
            PathType type;
            ReadFileSystem<?> compound = this.compounds[i];
            Object p = file.paths[i];
            if (p == null || (type = compound.typeOf(p)) != PathType.FILE) continue;
            return compound.getResource(p);
        }
        throw new IOException("No resource at " + file);
    }

    @Override
    public File getFile(Context path) {
        return null;
    }

    @Override
    public URL getURL(Context path) throws NullPointerException, IOException {
        return null;
    }
}

