/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.module;

import java.net.URL;
import java.util.HashMap;
import java.util.ServiceLoader;
import juzu.impl.common.JSON;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.PluginDescriptor;
import juzu.impl.plugin.module.ModuleContext;
import juzu.impl.plugin.module.ModulePlugin;
import juzu.impl.resource.ResourceResolver;

public class Module {
    public final ModuleContext context;
    private final HashMap<String, ModulePlugin> plugins;
    private final HashMap<String, PluginDescriptor> descriptors;

    public Module(final ModuleContext context) throws Exception {
        HashMap<String, ModulePlugin> plugins = new HashMap<String, ModulePlugin>();
        for (ModulePlugin plugin : ServiceLoader.load(ModulePlugin.class)) {
            plugins.put(plugin.getName(), plugin);
        }
        ResourceResolver classPathResolver = new ResourceResolver(){

            @Override
            public URL resolve(String uri) {
                return context.getClassLoader().getResource(uri.substring(1));
            }
        };
        HashMap<String, PluginDescriptor> descriptors = new HashMap<String, PluginDescriptor>();
        for (ModulePlugin plugin : plugins.values()) {
            JSON pluginConfig;
            PluginContext pluginContext;
            PluginDescriptor desc = plugin.init(pluginContext = new PluginContext(pluginConfig = context.getConfig().getJSON(plugin.getName()), context, classPathResolver){
                final /* synthetic */ JSON val$pluginConfig;
                final /* synthetic */ ModuleContext val$context;
                final /* synthetic */ ResourceResolver val$classPathResolver;
                {
                    this.val$pluginConfig = jSON;
                    this.val$context = moduleContext;
                    this.val$classPathResolver = resourceResolver;
                }

                @Override
                public JSON getConfig() {
                    return this.val$pluginConfig;
                }

                @Override
                public ClassLoader getClassLoader() {
                    return this.val$context.getClassLoader();
                }

                @Override
                public ResourceResolver getServerResolver() {
                    return this.val$context.getServerResolver();
                }

                @Override
                public ResourceResolver getApplicationResolver() {
                    return this.val$classPathResolver;
                }
            });
            if (desc == null) continue;
            descriptors.put(plugin.getName(), desc);
        }
        this.plugins = plugins;
        this.descriptors = descriptors;
        this.context = context;
    }

    public ModulePlugin getPlugin(String name) {
        return this.plugins.get(name);
    }

    public <P extends ModulePlugin> P getPlugin(Class<P> type) {
        for (ModulePlugin plugin : this.plugins.values()) {
            if (!type.isInstance(plugin)) continue;
            return (P)((ModulePlugin)type.cast(plugin));
        }
        return null;
    }
}

