/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import juzu.MimeType;
import juzu.PropertyType;
import juzu.Response;
import juzu.impl.common.Spliterator;
import juzu.impl.common.Tools;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.request.BeanParameter;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.ControlParameter;
import juzu.impl.request.ControllerHandler;
import juzu.impl.request.EntityMarshaller;
import juzu.impl.request.EntityUnmarshaller;
import juzu.impl.request.PhaseParameter;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.impl.value.ValueType;
import juzu.io.Streamable;
import juzu.request.ApplicationContext;
import juzu.request.ClientContext;
import juzu.request.HttpContext;
import juzu.request.Phase;
import juzu.request.RequestContext;
import juzu.request.RequestLifeCycle;
import juzu.request.RequestParameter;
import juzu.request.SecurityContext;
import juzu.request.UserContext;

public abstract class Stage {
    private int index = 0;
    final Request request;
    final List<RequestFilter<?>> filters;

    public Request getRequest() {
        return this.request;
    }

    public Stage(Request request) {
        ArrayList filters = new ArrayList();
        for (RequestFilter filter : request.controllerPlugin.getInjectionContext().resolveInstances(RequestFilter.class)) {
            if (!this.getClass().isAssignableFrom(filter.getStageType())) continue;
            filters.add(filter);
        }
        this.request = request;
        this.filters = filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response invoke() {
        if (this.index >= 0 && this.index < this.filters.size()) {
            RequestFilter<?> plugin = this.filters.get(this.index);
            try {
                ++this.index;
                Response response = (Response)plugin.handle(this);
                return response;
            }
            finally {
                --this.index;
            }
        }
        if (this.index == this.filters.size()) {
            return this.response();
        }
        throw new AssertionError();
    }

    protected abstract Response response();

    public static class Invoke
    extends Stage {
        private final RequestContext context;
        private final Object controller;
        private final Object[] args;

        public Invoke(Request request, RequestContext context, Object controller, Object[] args) {
            super(request);
            this.controller = controller;
            this.context = context;
            this.args = args;
        }

        public Object getController() {
            return this.controller;
        }

        public Object[] getArguments() {
            return this.args;
        }

        public Method getMethod() {
            return this.context.getHandler().getMethod();
        }

        @Override
        protected Response response() {
            try {
                Annotation annotation;
                Object ret = this.context.getHandler().getMethod().invoke(this.controller, this.args);
                MimeType mimeType = null;
                Annotation[] arr$ = this.context.getHandler().getMethod().getDeclaredAnnotations();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && ((mimeType = (annotation = arr$[i$]) instanceof MimeType ? (MimeType)annotation : annotation.annotationType().getAnnotation(MimeType.class)) == null || mimeType.value().length <= 0); ++i$) {
                }
                if (ret instanceof Response) {
                    Response resp = (Response)ret;
                    if (mimeType != null) {
                        resp = resp.with(PropertyType.MIME_TYPE, mimeType.value()[0]);
                    }
                    return resp;
                }
                if (ret != null && mimeType != null) {
                    for (EntityMarshaller writer : Tools.loadService(EntityMarshaller.class, this.request.controllerPlugin.getApplication().getClassLoader())) {
                        for (String s : mimeType.value()) {
                            Streamable streamable = writer.marshall(s, this.context.getHandler().getMethod(), ret);
                            if (streamable == null) continue;
                            return ((Response.Status)Response.ok().with((PropertyType)PropertyType.MIME_TYPE, s)).body(streamable);
                        }
                    }
                }
                return null;
            }
            catch (InvocationTargetException e) {
                return Response.error(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException("hanle me gracefully", e);
            }
        }
    }

    public static class LifeCycle
    extends Stage {
        private final RequestContext context;
        private final Object controller;
        private final Object[] args;

        public LifeCycle(Request request, RequestContext context, Object controller, Object[] args) {
            super(request);
            this.context = context;
            this.controller = controller;
            this.args = args;
        }

        @Override
        protected Response response() {
            Response response;
            if (this.controller instanceof RequestLifeCycle) {
                try {
                    ((RequestLifeCycle)this.controller).beginRequest(this.context);
                }
                catch (Exception e) {
                    return new Response.Error(e);
                }
            }
            if ((response = this.context.getResponse()) == null) {
                Invoke invokeStage = new Invoke(this.request, this.context, this.controller, this.args);
                response = invokeStage.invoke();
                this.context.setResponse(response);
                if (this.controller instanceof RequestLifeCycle) {
                    try {
                        ((RequestLifeCycle)this.controller).endRequest(this.context);
                    }
                    catch (Exception e) {
                        this.context.setResponse(Response.error(e));
                    }
                }
                response = this.context.getResponse();
            }
            return response;
        }
    }

    public static class Handler
    extends Stage {
        public Handler(Request request) {
            super(request);
        }

        @Override
        public Response response() {
            ControllerHandler<?> handler = this.request.getHandler();
            InjectionContext<?, ?> manager = this.request.controllerPlugin.getInjectionContext();
            Class<?> controllerType = handler.getType();
            this.request.controllerLifeCycle = manager.get(controllerType);
            if (this.request.controllerLifeCycle != null) {
                Object controller;
                RequestContext context = new RequestContext(this.request, handler);
                Object[] args = new Object[handler.getParameters().size()];
                for (int i = 0; i < args.length; ++i) {
                    Object value;
                    ControlParameter parameter = handler.getParameters().get(i);
                    if (parameter instanceof PhaseParameter) {
                        PhaseParameter phaseParam = (PhaseParameter)parameter;
                        RequestParameter requestParam = this.request.getParameterArguments().get(phaseParam.getMappedName());
                        if (requestParam != null) {
                            ValueType valueType = this.request.controllerPlugin.resolveValueType(phaseParam.getValueType());
                            if (valueType != null) {
                                ArrayList values = new ArrayList(requestParam.size());
                                for (String s : requestParam) {
                                    Object converted;
                                    try {
                                        converted = valueType.parse(phaseParam.getAnnotations(), s);
                                    }
                                    catch (Exception e) {
                                        return Response.error(e);
                                    }
                                    values.add(converted);
                                }
                                value = phaseParam.getValue(values);
                            } else {
                                value = null;
                            }
                        } else {
                            value = null;
                        }
                        Class<?> type = phaseParam.getType();
                        if (value == null && type.isPrimitive()) {
                            if (type == Integer.TYPE) {
                                value = 0;
                            } else if (type == Long.TYPE) {
                                value = 0L;
                            } else if (type == Byte.TYPE) {
                                value = (byte)0;
                            } else if (type == Short.TYPE) {
                                value = (short)0;
                            } else if (type == Boolean.TYPE) {
                                value = false;
                            } else if (type == Float.TYPE) {
                                value = Float.valueOf(0.0f);
                            } else if (type == Double.TYPE) {
                                value = 0.0;
                            } else if (type == Character.TYPE) {
                                value = Character.valueOf('\u0000');
                            }
                        }
                    } else if (parameter instanceof BeanParameter) {
                        BeanParameter beanParam = (BeanParameter)parameter;
                        Class<?> type = beanParam.getType();
                        try {
                            value = beanParam.createMappedBean(this.request.controllerPlugin, handler.requiresPrefix, type, beanParam.getName(), this.request.getParameterArguments());
                        }
                        catch (Exception e) {
                            value = null;
                        }
                    } else {
                        ContextualParameter contextualParameter = (ContextualParameter)parameter;
                        value = this.request.getContextualArguments().get(contextualParameter);
                        if (value == null) {
                            Class<?> contextualType = contextualParameter.getType();
                            if (RequestContext.class.isAssignableFrom(contextualType)) {
                                value = context;
                            } else if (HttpContext.class.isAssignableFrom(contextualType)) {
                                value = this.request.getHttpContext();
                            } else if (SecurityContext.class.isAssignableFrom(contextualType)) {
                                value = this.request.getSecurityContext();
                            } else if (ApplicationContext.class.isAssignableFrom(contextualType)) {
                                value = this.request.getApplicationContext();
                            } else if (UserContext.class.isAssignableFrom(contextualType)) {
                                value = this.request.getUserContext();
                            } else if (ClientContext.class.isAssignableFrom(contextualType) && (this.request.bridge.getPhase() == Phase.RESOURCE || this.request.bridge.getPhase() == Phase.ACTION)) {
                                value = this.request.getClientContext();
                            }
                        }
                    }
                    args[i] = value;
                }
                try {
                    controller = this.request.controllerLifeCycle.get();
                }
                catch (InvocationTargetException e) {
                    return Response.error(e.getCause());
                }
                LifeCycle lifeCycle = new LifeCycle(this.request, context, controller, args);
                return lifeCycle.invoke();
            }
            return null;
        }
    }

    public static class Unmarshalling
    extends Stage {
        public Unmarshalling(Request request) {
            super(request);
        }

        @Override
        protected Response response() {
            String mediaType;
            Spliterator i;
            String contentType;
            Map<String, RequestParameter> parameterArguments = this.request.getParameterArguments();
            parameterArguments.putAll(this.request.bridge.getRequestArguments());
            Map<ContextualParameter, Object> contextualArguments = this.request.getContextualArguments();
            for (ControlParameter controlParameter : this.request.handler.getParameters()) {
                ContextualParameter contextualParameter;
                if (!(controlParameter instanceof ContextualParameter) || contextualArguments.containsKey(contextualParameter = (ContextualParameter)controlParameter)) continue;
                contextualArguments.put(contextualParameter, null);
            }
            contextualArguments.putAll(this.request.bridge.getContextualArguments(contextualArguments.keySet()));
            ClientContext clientContext = this.request.bridge.getClientContext();
            if (clientContext != null && (contentType = clientContext.getContentType()) != null && (i = new Spliterator(contentType, ';')).hasNext() && !(mediaType = i.next().trim()).equals("application/x-www-form-urlencoded")) {
                for (EntityUnmarshaller reader : Tools.loadService(EntityUnmarshaller.class, this.request.controllerPlugin.getApplication().getClassLoader())) {
                    try {
                        if (!reader.accept(mediaType)) continue;
                        reader.unmarshall(mediaType, clientContext, contextualArguments.entrySet(), parameterArguments);
                        break;
                    }
                    catch (IOException e) {
                        throw new UnsupportedOperationException("handle me gracefully", e);
                    }
                }
            }
            return new Handler(this.request).invoke();
        }
    }
}

