/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.util.BitSet;
import juzu.impl.common.Tools;
import juzu.impl.router.RERef;
import juzu.impl.router.Route;
import juzu.impl.router.RouterConfigException;
import juzu.impl.router.regex.RE;
import juzu.impl.router.regex.REFactory;

public class Router
extends Route {
    private static final BitSet escapeSet;
    private final REFactory factory;
    private RERef[] regexes;
    final char separatorEscape;
    final char separatorEscapeNible1;
    final char separatorEscapeNible2;

    public Router() throws RouterConfigException {
        this('_', REFactory.JAVA);
    }

    public Router(char separatorEscape) throws RouterConfigException {
        this(separatorEscape, REFactory.JAVA);
    }

    public Router(char separatorEscape, REFactory regexFactory) throws RouterConfigException {
        super(null, 0);
        int i = separatorEscape & 0xFFFFFF80;
        if (i > 0 || !escapeSet.get(separatorEscape)) {
            throw new RouterConfigException("Char " + separatorEscape + " cannot be used a separator escape");
        }
        String s = Integer.toString(separatorEscape, 16).toUpperCase();
        this.separatorEscapeNible1 = s.charAt(0);
        this.separatorEscapeNible2 = s.charAt(1);
        this.separatorEscape = separatorEscape;
        this.regexes = new RERef[0];
        this.factory = regexFactory;
    }

    RERef compile(String pattern) {
        for (RERef regex : this.regexes) {
            if (!regex.re.getPattern().equals(pattern)) continue;
            return regex;
        }
        RE regex = this.factory.compile(pattern);
        RERef holder = new RERef(this.regexes.length, regex);
        this.regexes = Tools.appendTo(this.regexes, holder);
        return holder;
    }

    @Override
    public String toString() {
        return "Router[" + super.toString() + "]";
    }

    static {
        BitSet bs = new BitSet();
        bs.set(95);
        bs.set(46);
        bs.set(45);
        bs.set(126);
        bs.set(33);
        bs.set(36);
        bs.set(38);
        bs.set(43);
        bs.set(58);
        bs.set(64);
        escapeSet = bs;
    }
}

