/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import juzu.asset.AssetLocation;
import juzu.impl.bridge.spi.web.HttpStream;
import juzu.impl.bridge.spi.web.WebRequestContext;
import juzu.impl.common.FormURLEncodedParser;
import juzu.impl.common.JUL;
import juzu.impl.common.Lexers;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.RunMode;
import juzu.impl.common.Spliterator;
import juzu.impl.common.Tools;
import juzu.impl.io.BinaryOutputStream;
import juzu.io.Stream;
import juzu.request.RequestParameter;

public class ServletRequestContext
extends WebRequestContext {
    static final Logger log = JUL.getLogger(ServletRequestContext.class.getName());
    final HttpServletRequest req;
    final HttpServletResponse resp;
    final String path;
    final String requestPath;
    final Map<String, RequestParameter> requestParameters;
    final Charset defaultEncoding;
    private AsyncContext context;
    private final String prefix;
    private final RunMode runMode;

    public ServletRequestContext(Name application, Charset defaultEncoding, HttpServletRequest req, HttpServletResponse resp, String path, RunMode runMode) {
        Spliterator i;
        String contentType;
        Map requestParameters = Collections.emptyMap();
        String query = req.getQueryString();
        if (query != null) {
            Iterator<RequestParameter> i2 = Lexers.queryParser(query);
            while (i2.hasNext()) {
                if (requestParameters.isEmpty()) {
                    requestParameters = new HashMap();
                }
                RequestParameter parameter = i2.next();
                parameter.appendTo(requestParameters);
            }
        }
        if ("POST".equals(req.getMethod()) && (contentType = req.getContentType()) != null && contentType.length() > 0 && "application/x-www-form-urlencoded".equals((i = new Spliterator(contentType, ';')).next().trim())) {
            Charset charset = defaultEncoding;
            while (i.hasNext()) {
                String v = i.next().trim();
                if (!v.startsWith("charset=")) continue;
                charset = Charset.forName(v.substring("charset=".length()));
            }
            try {
                byte[] bytes = Tools.copy((InputStream)req.getInputStream(), new ByteArrayOutputStream()).toByteArray();
                String form = new String(bytes, charset);
                FormURLEncodedParser parser = new FormURLEncodedParser(defaultEncoding, form, 0, form.length());
                for (RequestParameter parameter : parser) {
                    if (requestParameters.isEmpty()) {
                        requestParameters = new HashMap();
                    }
                    parameter.appendTo(requestParameters);
                }
            }
            catch (IOException e) {
                log.error("Cannot parse form post", e);
            }
        }
        StringBuilder prefix = new StringBuilder();
        for (String atom : application) {
            prefix.append('/').append(atom);
        }
        prefix.append("/assets/");
        this.defaultEncoding = defaultEncoding;
        this.requestPath = req.getRequestURI().substring(req.getContextPath().length());
        this.requestParameters = requestParameters;
        this.req = req;
        this.path = path;
        this.resp = resp;
        this.prefix = prefix.toString();
        this.runMode = runMode;
    }

    @Override
    public RunMode getRunMode() {
        return this.runMode;
    }

    @Override
    public Map<String, RequestParameter> getParameters() {
        return this.requestParameters;
    }

    @Override
    public String getRequestPath() {
        return this.requestPath;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getRequestURI() {
        return this.req.getRequestURI();
    }

    synchronized void endAsync() {
        if (this.context != null) {
            log.trace("Completing async");
            this.context.complete();
        }
    }

    synchronized AsyncContext beginAsync() {
        if (this.req.isAsyncStarted()) {
            this.context = this.req.getAsyncContext();
        } else {
            log.trace("Starting async mode");
            this.context = this.req.startAsync();
        }
        return this.context;
    }

    @Override
    public HttpStream getStream(int status) {
        return new ServletStream(status, this.defaultEncoding);
    }

    @Override
    public void setHeaders(Iterable<Map.Entry<String, String[]>> headers) {
        for (Map.Entry<String, String[]> header : headers) {
            this.resp.setHeader(header.getKey(), header.getValue()[0]);
        }
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.resp.sendRedirect(location);
    }

    @Override
    public void setContentType(String mimeType, Charset charset) {
        String name = charset.name();
        this.resp.setCharacterEncoding(name);
        this.resp.setContentType(mimeType);
    }

    @Override
    public void setStatus(int status) {
        this.resp.setStatus(status);
    }

    @Override
    public void renderAssetURL(AssetLocation location, String uri, Appendable appendable) throws IOException {
        switch (location) {
            case SERVER: {
                if (!uri.startsWith("/")) {
                    appendable.append(this.req.getContextPath());
                    appendable.append('/');
                }
                appendable.append(uri);
                break;
            }
            case APPLICATION: {
                appendable.append(this.req.getContextPath()).append("/assets");
                if (location == AssetLocation.APPLICATION && !uri.startsWith("/")) {
                    appendable.append(this.prefix);
                }
                appendable.append(uri);
                break;
            }
            case URL: {
                appendable.append(uri);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public class ServletStream
    extends HttpStream {
        private Stream dataStream;

        ServletStream(int status, Charset encoding) {
            super(ServletRequestContext.this, status, encoding);
        }

        @Override
        public void setStatusCode(int status) {
            ServletRequestContext.this.resp.setStatus(status);
        }

        @Override
        protected Stream getDataStream(boolean create) {
            if (this.dataStream == null && create) {
                try {
                    this.dataStream = new BinaryOutputStream(this.encoding, (OutputStream)ServletRequestContext.this.resp.getOutputStream());
                }
                catch (IOException e) {
                    throw new UnsupportedOperationException("Handle me gracefully", e);
                }
            }
            return this.dataStream;
        }

        @Override
        protected void beginAsync() {
            ServletRequestContext.this.beginAsync();
        }

        @Override
        protected void endAsync() {
            ServletRequestContext.this.endAsync();
        }
    }
}

