/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller.metamodel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;
import juzu.Action;
import juzu.Application;
import juzu.Consumes;
import juzu.Resource;
import juzu.View;
import juzu.impl.common.Cardinality;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.plugin.controller.descriptor.ControllerDescriptor;
import juzu.impl.plugin.controller.metamodel.BeanParameterMetaModel;
import juzu.impl.plugin.controller.metamodel.ControllerMetaModel;
import juzu.impl.plugin.controller.metamodel.ControllersMetaModel;
import juzu.impl.plugin.controller.metamodel.HandlerMetaModel;
import juzu.impl.plugin.controller.metamodel.ParameterMetaModel;
import juzu.impl.plugin.controller.metamodel.PhaseParameterMetaModel;
import juzu.impl.plugin.module.metamodel.ModuleMetaModel;
import juzu.impl.request.BeanParameter;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.ControlParameter;
import juzu.impl.request.ControllerHandler;
import juzu.impl.request.PhaseParameter;
import juzu.impl.request.Request;
import juzu.impl.value.ValueType;
import juzu.processor.MainProcessor;
import juzu.request.Phase;

public class ControllerMetaModelPlugin
extends ApplicationMetaModelPlugin {
    private static final String METHOD_DESCRIPTOR = ControllerHandler.class.getSimpleName();
    private static final String CONTROLLER_DESCRIPTOR = ControllerDescriptor.class.getSimpleName();
    private static final String PARAMETER = ControlParameter.class.getSimpleName();
    private static final String PHASE_PARAMETER = PhaseParameter.class.getSimpleName();
    private static final String CONTEXTUAL_PARAMETER = ContextualParameter.class.getSimpleName();
    private static final String BEAN_PARAMETER = BeanParameter.class.getSimpleName();
    private static final String PHASE = Phase.class.getSimpleName();
    private static final String TOOLS = Tools.class.getSimpleName();
    public static final String CARDINALITY = Cardinality.class.getSimpleName();
    private HashSet<ControllerMetaModel> written = new HashSet();
    private static final String SERVICES = "META-INF/services/" + ValueType.class.getName();
    final HashSet<ElementHandle.Type> valueTypes = new HashSet();
    private static final HashMap<Phase, String> DISPATCH_TYPE = new HashMap();

    public ControllerMetaModelPlugin() {
        super("controller");
    }

    @Override
    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Tools.set(View.class, Action.class, Consumes.class, Resource.class);
    }

    @Override
    public void postActivate(ModuleMetaModel applications) {
        Enumeration<URL> services;
        this.valueTypes.clear();
        for (ValueType<?> valueType : ValueType.DEFAULT) {
            for (Class<?> type : valueType.getTypes()) {
                this.valueTypes.add(ElementHandle.Type.create(Name.create(type)));
            }
        }
        try {
            services = MainProcessor.class.getClassLoader().getResources(SERVICES);
        }
        catch (IOException e) {
            services = null;
        }
        if (services != null) {
            while (services.hasMoreElements()) {
                URL url = services.nextElement();
                try {
                    String line;
                    InputStream in = url.openStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, Tools.UTF_8));
                    while ((line = reader.readLine()) != null) {
                        DeclaredType declaredArgumentType;
                        Element declaredArgumentElement;
                        TypeMirror argument;
                        TypeMirror superType;
                        List<? extends TypeMirror> superTypes;
                        String providerName = line.trim();
                        TypeElement provider = applications.getProcessingContext().getTypeElement(providerName);
                        if (provider.getKind() != ElementKind.CLASS || (superTypes = applications.getProcessingContext().directSupertypes(provider.asType())).size() <= 0 || (superType = superTypes.get(0)).getKind() != TypeKind.DECLARED) continue;
                        DeclaredType declaredTypeSuper = (DeclaredType)superType;
                        TypeElement declaredSuperElement = (TypeElement)declaredTypeSuper.asElement();
                        if (!ValueType.class.getName().equals(declaredSuperElement.getQualifiedName().toString()) || !((argument = declaredTypeSuper.getTypeArguments().get(0)) instanceof DeclaredType) || !((declaredArgumentElement = (declaredArgumentType = (DeclaredType)argument).asElement()) instanceof TypeElement)) continue;
                        ElementHandle.Type valueType = ElementHandle.Type.create((TypeElement)declaredArgumentElement);
                        this.valueTypes.add(valueType);
                    }
                }
                catch (IOException e) {
                }
            }
        }
    }

    @Override
    public void init(ApplicationMetaModel application) {
        ControllersMetaModel controllers = new ControllersMetaModel(this);
        PackageElement pkg = application.model.processingContext.get(application.getHandle());
        AnnotationMirror annotation = Tools.getAnnotation(pkg, Application.class.getName());
        AnnotationState values = AnnotationState.create(annotation);
        Boolean escapeXML = (Boolean)values.get("escapeXML");
        ElementHandle.Type defaultControllerElt = (ElementHandle.Type)values.get("defaultController");
        ElementHandle.Type errorControllerElt = (ElementHandle.Type)values.get("errorController");
        controllers.escapeXML = escapeXML;
        controllers.defaultController = defaultControllerElt != null ? defaultControllerElt.getName() : null;
        controllers.errorController = errorControllerElt != null ? errorControllerElt.getName() : null;
        application.addChild(ControllersMetaModel.KEY, controllers);
    }

    @Override
    public void processAnnotationAdded(ApplicationMetaModel application, AnnotationKey key, AnnotationState added) {
        ElementHandle.Method methodHandle = (ElementHandle.Method)key.getElement();
        ElementHandle.Type controllerHandle = methodHandle.getType();
        ControllersMetaModel controllers = application.getChild(ControllersMetaModel.KEY);
        ControllerMetaModel controller = controllers.get(controllerHandle);
        if (controller == null) {
            controller = new ControllerMetaModel(controllerHandle);
            controllers.add(controller);
        }
        controller.addMethod(application.model, key, added);
    }

    @Override
    public void processAnnotationRemoved(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        ElementHandle.Method methodHandle = (ElementHandle.Method)key.getElement();
        ElementHandle.Type controllerHandle = ElementHandle.Type.create(methodHandle.getTypeName());
        ControllersMetaModel controllers = metaModel.getChild(ControllersMetaModel.KEY);
        ControllerMetaModel controller = controllers.get(controllerHandle);
        if (controller != null) {
            controller.removeMethod(methodHandle);
            if (controller.getHandlers().isEmpty()) {
                controller.remove();
            }
        }
    }

    @Override
    public void postProcessAnnotations(ApplicationMetaModel application) {
        for (ControllerMetaModel controller : application.getChild(ControllersMetaModel.KEY)) {
            if (!controller.modified) continue;
            controller.modified = false;
            controller.queue(MetaModelEvent.createUpdated(controller));
        }
    }

    @Override
    public void processEvent(ApplicationMetaModel application, MetaModelEvent event) {
        MetaModelObject obj = event.getObject();
        if (obj instanceof ControllerMetaModel) {
            switch (event.getType()) {
                case 1: {
                    break;
                }
                case 0: 
                case 2: {
                    ControllerMetaModel controller = (ControllerMetaModel)obj;
                    this.written.add(controller);
                }
            }
        }
    }

    @Override
    public JSON getDescriptor(ApplicationMetaModel application) {
        ControllersMetaModel ac = application.getChild(ControllersMetaModel.KEY);
        ArrayList<String> controllers = new ArrayList<String>();
        for (ControllerMetaModel controller : ac) {
            controllers.add(controller.getHandle().getName() + "_");
        }
        JSON config = new JSON();
        config.set("default", ac.defaultController != null ? ac.defaultController.toString() : null);
        config.set("error", ac.errorController != null ? ac.errorController.toString() : null);
        config.set("escapeXML", ac.escapeXML);
        config.map("controllers", controllers);
        return config;
    }

    @Override
    public void postProcessEvents(ApplicationMetaModel application) {
        for (ControllerMetaModel controller : application.getChild(ControllersMetaModel.KEY)) {
            TypeElement controllerElt = application.getProcessingContext().get(controller.getHandle());
            if (!controllerElt.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            throw ControllerMetaModel.CONTROLLER_IS_ABSTRACT.failure((Element)controllerElt, controller.handle.getName());
        }
        Iterator<ControllerMetaModel> i = this.written.iterator();
        while (i.hasNext()) {
            ControllerMetaModel controller;
            controller = i.next();
            i.remove();
            this.emitController(application.model.processingContext, controller);
        }
    }

    private void emitController(ProcessingContext env, ControllerMetaModel controller) throws ProcessingException {
        Name fqn = controller.getHandle().getName();
        TypeElement origin = env.get(controller.getHandle());
        Collection<HandlerMetaModel> methods = controller.getHandlers();
        Writer writer = null;
        try {
            JavaFileObject file = env.createSourceFile(fqn + "_", origin);
            writer = file.openWriter();
            writer.append("package ").append(fqn.getParent()).append(";\n");
            writer.append("import ").append(ControllerHandler.class.getCanonicalName()).append(";\n");
            writer.append("import ").append(ControlParameter.class.getCanonicalName()).append(";\n");
            writer.append("import ").append(PhaseParameter.class.getCanonicalName()).append(";\n");
            writer.append("import ").append(ContextualParameter.class.getCanonicalName()).append(";\n");
            writer.append("import ").append(BeanParameter.class.getCanonicalName()).append(";\n");
            writer.append("import ").append(Tools.class.getCanonicalName()).append(";\n");
            writer.append("import ").append(Arrays.class.getCanonicalName()).append(";\n");
            writer.append("import ").append(Phase.class.getCanonicalName()).append(";\n");
            writer.append("import ").append(ControllerDescriptor.class.getCanonicalName()).append(";\n");
            writer.append("import ").append(Generated.class.getCanonicalName()).append(";\n");
            writer.append("import ").append(Cardinality.class.getCanonicalName()).append(";\n");
            writer.append("import ").append(Request.class.getCanonicalName()).append(";\n");
            writer.append("@Generated(value={})\n");
            writer.append("public class ").append(fqn.getIdentifier()).append("_ {\n");
            writer.append("private static final Class<").append(fqn).append("> TYPE = ").append(fqn).append(".class;\n");
            int index = 0;
            for (HandlerMetaModel method : methods) {
                String methodRef = "method_" + index++;
                writer.append("private static final ").append(METHOD_DESCRIPTOR).append("<");
                Tools.nameOf(method.getPhase().getClass(), writer);
                writer.append("> ").append(methodRef).append(" = ");
                writer.append("new ").append(METHOD_DESCRIPTOR).append("<");
                Tools.nameOf(method.getPhase().getClass(), writer);
                writer.append(">(");
                if (method.getId() != null) {
                    writer.append("\"").append(method.getId()).append("\",");
                } else {
                    writer.append("null,");
                }
                writer.append(PHASE).append(".").append(method.getPhase().name()).append(",");
                writer.append("TYPE,");
                writer.append(TOOLS).append(".safeGetMethod(TYPE,\"").append(method.getName()).append("\"");
                for (ParameterMetaModel parameter : method.getParameters()) {
                    writer.append(",").append(parameter.type).append(".class");
                }
                writer.append(')');
                writer.append(", Arrays.<").append(PARAMETER).append(">asList(");
                for (int i = 0; i < method.getParameters().size(); ++i) {
                    ParameterMetaModel parameter;
                    parameter = method.getParameters().get(i);
                    if (i > 0) {
                        writer.append(',');
                    }
                    if (parameter instanceof BeanParameterMetaModel) {
                        writer.append("new ").append(BEAN_PARAMETER).append('(').append('\"').append(parameter.getName()).append('\"').append(',').append(parameter.type).append(".class").append(')');
                        continue;
                    }
                    if (parameter instanceof PhaseParameterMetaModel) {
                        PhaseParameterMetaModel phaseParameter = (PhaseParameterMetaModel)parameter;
                        writer.append("new ").append(PHASE_PARAMETER).append('(').append('\"').append(parameter.getName()).append('\"').append(',').append(parameter.type).append(".class").append(',').append(phaseParameter.valueType).append(".class").append(',').append(CARDINALITY).append('.').append(phaseParameter.getCardinality().name()).append(',');
                        if (phaseParameter.getAlias() != null) {
                            writer.append('\"').append(phaseParameter.getAlias()).append('\"');
                        } else {
                            writer.append("null");
                        }
                        writer.append(')');
                        continue;
                    }
                    writer.append("new ").append(CONTEXTUAL_PARAMETER).append('(').append('\"').append(parameter.getName()).append('\"').append(',').append(parameter.type).append(".class").append(')');
                }
                writer.append(')');
                writer.append(");\n");
                String dispatchType = DISPATCH_TYPE.get(method.getPhase());
                ArrayList<ParameterMetaModel> parameters = new ArrayList<ParameterMetaModel>(method.getParameters().size());
                for (ParameterMetaModel parameter : method.getParameters()) {
                    if (!(parameter instanceof PhaseParameterMetaModel) && !(parameter instanceof BeanParameterMetaModel)) continue;
                    parameters.add(parameter);
                }
                if (method.getPhase() == Phase.EVENT) continue;
                writer.append("public static ").append(dispatchType).append(" ").append(method.getName()).append("(");
                for (int i = 0; i < parameters.size(); ++i) {
                    ParameterMetaModel parameter;
                    parameter = (ParameterMetaModel)parameters.get(i);
                    if (i > 0) {
                        writer.append(',');
                    }
                    writer.append(parameter.type).append(" ").append(parameter.getName());
                }
                writer.append(") { return Request.create").append(method.getPhase().getClass().getSimpleName()).append("Dispatch(").append(methodRef);
                switch (parameters.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        writer.append(",(Object)").append(((ParameterMetaModel)parameters.get(0)).getName());
                        break;
                    }
                    default: {
                        writer.append(",new Object[]{");
                        for (int j = 0; j < parameters.size(); ++j) {
                            if (j > 0) {
                                writer.append(",");
                            }
                            writer.append(((ParameterMetaModel)parameters.get(j)).getName());
                        }
                        writer.append('}');
                    }
                }
                writer.append("); }\n");
            }
            writer.append("public static final ").append(CONTROLLER_DESCRIPTOR).append(" DESCRIPTOR = new ").append(CONTROLLER_DESCRIPTOR).append("(");
            writer.append("TYPE,Arrays.<").append(METHOD_DESCRIPTOR).append("<?>>asList(");
            for (int j = 0; j < methods.size(); ++j) {
                if (j > 0) {
                    writer.append(',');
                }
                writer.append("method_").append(Integer.toString(j));
            }
            writer.append(")");
            writer.append(");\n");
            writer.append("}\n");
            env.info("Generated controller companion " + fqn + "_" + " as " + file.toUri());
        }
        catch (IOException e) {
            try {
                throw ControllerMetaModel.CANNOT_WRITE_CONTROLLER_COMPANION.failure(e, origin, controller.getHandle().getName());
            }
            catch (Throwable throwable) {
                Tools.safeClose(writer);
                throw throwable;
            }
        }
        Tools.safeClose(writer);
    }

    static {
        DISPATCH_TYPE.put(Phase.ACTION, Tools.getName(Phase.Action.Dispatch.class));
        DISPATCH_TYPE.put(Phase.VIEW, Tools.getName(Phase.View.Dispatch.class));
        DISPATCH_TYPE.put(Phase.RESOURCE, Tools.getName(Phase.Resource.Dispatch.class));
    }
}

