/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.util.List;
import juzu.impl.common.Cardinality;
import juzu.impl.common.Tools;
import juzu.impl.request.ControlParameter;

public class PhaseParameter<V>
extends ControlParameter {
    private final Cardinality cardinality;
    private final String alias;
    private final Class<V> valueType;

    public PhaseParameter(String name, Class<?> type, Class<V> valueType, Cardinality cardinality, String alias) throws NullPointerException {
        super(name, type);
        if (cardinality == null) {
            throw new NullPointerException("No null parameter cardinality accepted");
        }
        this.cardinality = cardinality;
        this.alias = alias;
        this.valueType = valueType;
    }

    public PhaseParameter(String name, AnnotatedElement annotations, Class<?> type, Class<V> valueType, Cardinality cardinality, String alias) throws NullPointerException {
        super(name, annotations, type);
        if (cardinality == null) {
            throw new NullPointerException("No null parameter cardinality accepted");
        }
        this.cardinality = cardinality;
        this.alias = alias;
        this.valueType = valueType;
    }

    public String getMappedName() {
        return this.alias != null ? this.alias : this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public Class<V> getValueType() {
        return this.valueType;
    }

    public Object getValue(List<V> values) {
        switch (this.cardinality) {
            case SINGLE: {
                return values.size() > 0 ? values.get(0) : null;
            }
            case ARRAY: {
                Object array = Array.newInstance(this.getValueType(), values.size());
                for (int i = 0; i < values.size(); ++i) {
                    Array.set(array, i, values.get(i));
                }
                return array;
            }
            case LIST: {
                return values;
            }
        }
        throw new UnsupportedOperationException("Handle me gracefully");
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PhaseParameter) {
            PhaseParameter that = (PhaseParameter)obj;
            return super.equals(that) && this.cardinality.equals((Object)that.cardinality) && Tools.safeEquals(this.alias, that.alias);
        }
        return false;
    }
}

