/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.bridge.servlet.JuzuServlet;
import juzu.impl.asset.AssetServlet;
import juzu.impl.common.RunMode;
import juzu.impl.common.Tools;
import juzu.impl.inject.spi.InjectorProvider;

public class DescriptorBuilder {
    public static DescriptorBuilder DEFAULT = new DescriptorBuilder(InjectorProvider.GUICE, Tools.ISO_8859_1, RunMode.PROD, null, new String[0], new int[0], new String[0], new String[0], new String[0], new String[0], new String[0], new Integer[0], new Boolean[0], new String[0], new String[0]);
    private final RunMode runMode;
    private final String sourcePath;
    private final InjectorProvider injector;
    private final String[] applicationNames;
    private final int[] applicationTypes;
    private final String[] urlPatterns;
    private final Charset requestEncoding;
    private final String[] servletsName;
    private final String[] servletsUrlPattern;
    private final String[] servletsClass;
    private final Integer[] servletsLoadOnStartup;
    private final Boolean[] servletsAsync;
    private final String[] listenersClass;
    private final String[] resourcesEnvRefName;
    private final String[] resourcesEnvRefType;

    protected DescriptorBuilder(DescriptorBuilder other) {
        this(other.injector, other.requestEncoding, other.runMode, other.sourcePath, other.applicationNames, other.applicationTypes, other.urlPatterns, other.listenersClass, other.servletsName, other.servletsUrlPattern, other.servletsClass, other.servletsLoadOnStartup, other.servletsAsync, other.resourcesEnvRefName, other.resourcesEnvRefType);
    }

    private DescriptorBuilder(InjectorProvider injector, Charset requestEncoding, RunMode runMode, String sourcePath, String[] applicationNames, int[] applicationTypes, String[] urlPatterns, String[] listenersClass, String[] servletsName, String[] servletsUrlPattern, String[] servletsClass, Integer[] servletsLoadOnStartup, Boolean[] servletsAsync, String[] resourcesEnvRefName, String[] resourcesEnvRefType) {
        this.applicationNames = applicationNames;
        this.runMode = runMode;
        this.injector = injector;
        this.applicationTypes = applicationTypes;
        this.sourcePath = sourcePath;
        this.urlPatterns = urlPatterns;
        this.requestEncoding = requestEncoding;
        this.listenersClass = listenersClass;
        this.servletsName = servletsName;
        this.servletsUrlPattern = servletsUrlPattern;
        this.servletsClass = servletsClass;
        this.servletsLoadOnStartup = servletsLoadOnStartup;
        this.servletsAsync = servletsAsync;
        this.resourcesEnvRefName = resourcesEnvRefName;
        this.resourcesEnvRefType = resourcesEnvRefType;
    }

    public DescriptorBuilder runMode(RunMode runMode) {
        if (runMode == null) {
            throw new NullPointerException("No null run mode");
        }
        return new DescriptorBuilder(this.injector, this.requestEncoding, runMode, this.sourcePath, this.applicationNames, this.applicationTypes, this.urlPatterns, this.listenersClass, this.servletsName, this.servletsUrlPattern, this.servletsClass, this.servletsLoadOnStartup, this.servletsAsync, this.resourcesEnvRefName, this.resourcesEnvRefType);
    }

    public DescriptorBuilder injector(InjectorProvider injector) {
        if (injector == null) {
            throw new NullPointerException("No null injector");
        }
        return new DescriptorBuilder(injector, this.requestEncoding, this.runMode, this.sourcePath, this.applicationNames, this.applicationTypes, this.urlPatterns, this.listenersClass, this.servletsName, this.servletsUrlPattern, this.servletsClass, this.servletsLoadOnStartup, this.servletsAsync, this.resourcesEnvRefName, this.resourcesEnvRefType);
    }

    public DescriptorBuilder portletApp(String applicationName, String portletName) {
        return this.app(applicationName, 1, portletName);
    }

    public DescriptorBuilder servletApp(String applicationName) {
        return this.servletApp(applicationName, "/");
    }

    public DescriptorBuilder servletApp(String applicationName, String urlPattern) {
        if (urlPattern == null) {
            throw new NullPointerException("No null url pattern");
        }
        return this.app(applicationName, 0, urlPattern);
    }

    private DescriptorBuilder app(String applicationName, int applicationType, String urlPattern) {
        int[] tmp = Arrays.copyOf(this.applicationTypes, this.applicationTypes.length + 1);
        tmp[this.applicationTypes.length] = applicationType;
        return new DescriptorBuilder(this.injector, this.requestEncoding, this.runMode, this.sourcePath, Tools.appendTo(this.applicationNames, applicationName), tmp, Tools.appendTo(this.urlPatterns, urlPattern), this.listenersClass, this.servletsName, this.servletsUrlPattern, this.servletsClass, this.servletsLoadOnStartup, this.servletsAsync, this.resourcesEnvRefName, this.resourcesEnvRefType);
    }

    public DescriptorBuilder sourcePath(String sourcePath) {
        if (sourcePath == null) {
            throw new NullPointerException("No null source path");
        }
        return new DescriptorBuilder(this.injector, this.requestEncoding, this.runMode, sourcePath, this.applicationNames, this.applicationTypes, this.urlPatterns, this.listenersClass, this.servletsName, this.servletsUrlPattern, this.servletsClass, this.servletsLoadOnStartup, this.servletsAsync, this.resourcesEnvRefName, this.resourcesEnvRefType);
    }

    public DescriptorBuilder requestEncoding(Charset requestEncoding) {
        if (requestEncoding == null) {
            throw new NullPointerException("No null request encoding");
        }
        return new DescriptorBuilder(this.injector, requestEncoding, this.runMode, this.sourcePath, this.applicationNames, this.applicationTypes, this.urlPatterns, this.listenersClass, this.servletsName, this.servletsUrlPattern, this.servletsClass, this.servletsLoadOnStartup, this.servletsAsync, this.resourcesEnvRefName, this.resourcesEnvRefType);
    }

    public DescriptorBuilder listener(String listenerClass) {
        if (this.requestEncoding == null) {
            throw new NullPointerException("No null listener class");
        }
        return new DescriptorBuilder(this.injector, this.requestEncoding, this.runMode, this.sourcePath, this.applicationNames, this.applicationTypes, this.urlPatterns, Tools.appendTo(this.listenersClass, listenerClass), this.servletsName, this.servletsUrlPattern, this.servletsClass, this.servletsLoadOnStartup, this.servletsAsync, this.resourcesEnvRefName, this.resourcesEnvRefType);
    }

    public DescriptorBuilder servlet(String servletName, String servletUrlPattern, String servletClass, Integer servletLoadOnStartup, Boolean servletAsync) {
        return new DescriptorBuilder(this.injector, this.requestEncoding, this.runMode, this.sourcePath, this.applicationNames, this.applicationTypes, this.urlPatterns, this.listenersClass, Tools.appendTo(this.servletsName, servletName), Tools.appendTo(this.servletsUrlPattern, servletUrlPattern), Tools.appendTo(this.servletsClass, servletClass), Tools.appendTo(this.servletsLoadOnStartup, servletLoadOnStartup), Tools.appendTo(this.servletsAsync, servletAsync), this.resourcesEnvRefName, this.resourcesEnvRefType);
    }

    public DescriptorBuilder embedPortletContainer() {
        return this.servlet("EmbedServlet", "/embed/*", "org.gatein.pc.embed.EmbedServlet", 0, null);
    }

    public DescriptorBuilder resourceEnvRef(String name, String type) {
        return new DescriptorBuilder(this.injector, this.requestEncoding, this.runMode, this.sourcePath, this.applicationNames, this.applicationTypes, this.urlPatterns, this.listenersClass, this.servletsName, this.servletsUrlPattern, this.servletsClass, this.servletsLoadOnStartup, this.servletsAsync, Tools.appendTo(this.resourcesEnvRefName, name), Tools.appendTo(this.resourcesEnvRefType, type));
    }

    public Iterable<String> getApplications() {
        return Tools.iterable(this.applicationNames);
    }

    public String getURLPattern() {
        return this.urlPatterns.length > 0 ? this.urlPatterns[0] : null;
    }

    public RunMode getRunMode() {
        return this.runMode;
    }

    public InjectorProvider getInjector() {
        return this.injector;
    }

    public Charset getRequestEncoding() {
        return this.requestEncoding;
    }

    private void appendContextParam(StringBuilder buffer, String paramName, String paramValue) {
        buffer.append("<context-param>\n");
        buffer.append("<param-name>").append(paramName).append("</param-name>");
        buffer.append("<param-value>").append(paramValue).append("</param-value>");
        buffer.append("</context-param>\n");
    }

    private void appendServlet(StringBuilder buffer, Map<String, String> initParams, String servletName, String servletClass, Integer loadOnStartup, Boolean async) {
        buffer.append("<servlet>");
        buffer.append("<servlet-name>").append(servletName).append("</servlet-name>");
        buffer.append("<servlet-class>").append(servletClass).append("</servlet-class>");
        if (initParams.size() > 0) {
            for (Map.Entry<String, String> initParam : initParams.entrySet()) {
                buffer.append("<init-param>");
                buffer.append("<param-name>").append(initParam.getKey()).append("</param-name>");
                buffer.append("<param-value>").append(initParam.getValue()).append("</param-value>");
                buffer.append("</init-param>");
            }
        }
        if (loadOnStartup != null) {
            buffer.append("<load-on-startup>").append(loadOnStartup).append("</load-on-startup>");
        }
        if (async != null) {
            buffer.append("<async-supported>").append(async).append("</async-supported>");
        }
        buffer.append("</servlet>");
    }

    private void appendMapping(StringBuilder buffer, String servletName, String urlPattern) {
        buffer.append("<servlet-mapping>");
        buffer.append("<servlet-name>").append(servletName).append("</servlet-name>");
        buffer.append("<url-pattern>").append(urlPattern).append("</url-pattern>");
        buffer.append("</servlet-mapping>");
    }

    private void appendListener(StringBuilder buffer, String listenerClass) {
        buffer.append("<listener>");
        buffer.append("<listener-class>").append(listenerClass).append("</listener-class>");
        buffer.append("</listener>");
    }

    protected void appendWebXmlHeader(StringBuilder buffer) {
        buffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        buffer.append("<web-app xmlns=\"http://java.sun.com/xml/ns/javaee\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd\"\nversion=\"3.0\">\n");
    }

    protected void appendWebXmlFooter(StringBuilder buffer) {
        buffer.append("</web-app>");
    }

    public String toWebXml() {
        int i;
        StringBuilder buffer = new StringBuilder();
        this.appendWebXmlHeader(buffer);
        this.appendContextParam(buffer, "juzu.run_mode", this.runMode.getValue());
        this.appendContextParam(buffer, "juzu.inject", this.injector.getValue());
        this.appendContextParam(buffer, "juzu.request_encoding", this.requestEncoding.name());
        if (this.sourcePath != null) {
            this.appendContextParam(buffer, "juzu.src_path", this.sourcePath);
        }
        for (String listenerClass : this.listenersClass) {
            this.appendListener(buffer, listenerClass);
        }
        for (i = 0; i < this.applicationNames.length; ++i) {
            if (this.applicationTypes[i] != 0) continue;
            this.appendServlet(buffer, Collections.singletonMap("juzu.app_name", this.applicationNames[i]), "JuzuServlet-" + i, JuzuServlet.class.getName(), null, true);
            this.appendMapping(buffer, "JuzuServlet-" + i, this.urlPatterns[i]);
        }
        for (i = 0; i < this.servletsName.length; ++i) {
            this.appendServlet(buffer, Collections.emptyMap(), this.servletsName[i], this.servletsClass[i], this.servletsLoadOnStartup[i], this.servletsAsync[i]);
            this.appendMapping(buffer, this.servletsName[i], this.servletsUrlPattern[i]);
        }
        this.appendServlet(buffer, Collections.emptyMap(), "AssetServlet", AssetServlet.class.getName(), 0, null);
        this.appendMapping(buffer, "AssetServlet", "/assets/*");
        if (this.resourcesEnvRefName.length > 0) {
            for (i = 0; i < this.resourcesEnvRefName.length; ++i) {
                buffer.append("<resource-env-ref>");
                buffer.append("<resource-env-ref-name>").append(this.resourcesEnvRefName[i]).append("</resource-env-ref-name>");
                buffer.append("<resource-env-ref-type>").append(this.resourcesEnvRefType[i]).append("</resource-env-ref-type>");
                buffer.append("</resource-env-ref>");
            }
        }
        this.appendWebXmlFooter(buffer);
        return buffer.toString();
    }

    public String toPortletXml() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<portlet-app xmlns=\"http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd\"\nversion=\"2.0\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd\">");
        for (int i = 0; i < this.applicationNames.length; ++i) {
            if (this.applicationTypes[i] != 1) continue;
            buffer.append("<portlet>");
            buffer.append("<portlet-name>").append(this.urlPatterns[i]).append("</portlet-name>");
            buffer.append("<display-name xml:lang=\"EN\">").append(this.urlPatterns[i]).append("</display-name>");
            buffer.append("<portlet-class>").append(JuzuPortlet.class.getName()).append("</portlet-class>");
            buffer.append("<init-param>");
            buffer.append("<name>").append("juzu.app_name").append("</name>");
            buffer.append("<value>").append(this.applicationNames[i]).append("</value>");
            buffer.append("</init-param>");
            buffer.append("<supports>");
            buffer.append("<mime-type>text/html</mime-type>");
            buffer.append("</supports>");
            buffer.append("<portlet-info>");
            buffer.append("<title>").append(this.urlPatterns[i]).append(" Application</title>");
            buffer.append("</portlet-info>");
            buffer.append("</portlet>");
        }
        buffer.append("</portlet-app>");
        return buffer.toString();
    }
}

