/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.module;

import java.net.URL;
import java.util.HashMap;
import java.util.ServiceLoader;
import juzu.impl.common.JSON;
import juzu.impl.plugin.ServiceContext;
import juzu.impl.plugin.ServiceDescriptor;
import juzu.impl.plugin.module.ModuleContext;
import juzu.impl.plugin.module.ModuleService;
import juzu.impl.resource.ResourceResolver;

public class Module {
    public final ModuleContext context;
    private final HashMap<String, ModuleService> plugins;
    private final HashMap<String, ServiceDescriptor> descriptors;

    public Module(final ModuleContext context) throws Exception {
        HashMap<String, ModuleService> plugins = new HashMap<String, ModuleService>();
        for (ModuleService plugin : ServiceLoader.load(ModuleService.class)) {
            plugins.put(plugin.getName(), plugin);
        }
        ResourceResolver classPathResolver = new ResourceResolver(){

            @Override
            public URL resolve(String uri) {
                return context.getClassLoader().getResource(uri.substring(1));
            }
        };
        HashMap<String, ServiceDescriptor> descriptors = new HashMap<String, ServiceDescriptor>();
        for (ModuleService plugin : plugins.values()) {
            JSON pluginConfig;
            ServiceContext pluginContext;
            ServiceDescriptor desc = plugin.init(pluginContext = new ServiceContext(pluginConfig = context.getConfig().getJSON(plugin.getName()), context, classPathResolver){
                final /* synthetic */ JSON val$pluginConfig;
                final /* synthetic */ ModuleContext val$context;
                final /* synthetic */ ResourceResolver val$classPathResolver;
                {
                    this.val$pluginConfig = jSON;
                    this.val$context = moduleContext;
                    this.val$classPathResolver = resourceResolver;
                }

                @Override
                public JSON getConfig() {
                    return this.val$pluginConfig;
                }

                @Override
                public ClassLoader getClassLoader() {
                    return this.val$context.getClassLoader();
                }

                @Override
                public ResourceResolver getServerResolver() {
                    return this.val$context.getServerResolver();
                }

                @Override
                public ResourceResolver getApplicationResolver() {
                    return this.val$classPathResolver;
                }
            });
            if (desc == null) continue;
            descriptors.put(plugin.getName(), desc);
        }
        this.plugins = plugins;
        this.descriptors = descriptors;
        this.context = context;
    }

    public ModuleService getPlugin(String name) {
        return this.plugins.get(name);
    }

    public <P extends ModuleService> P getPlugin(Class<P> type) {
        for (ModuleService plugin : this.plugins.values()) {
            if (!type.isInstance(plugin)) continue;
            return (P)((ModuleService)type.cast(plugin));
        }
        return null;
    }
}

