/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.runtime;

import java.io.Closeable;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetServer;
import juzu.impl.common.Completion;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.RunMode;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.inject.spi.BeanLifeCycle;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.Injector;
import juzu.impl.plugin.application.Application;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.plugin.asset.AssetService;
import juzu.impl.resource.ResourceResolver;
import juzu.impl.runtime.ModuleRuntime;

public class ApplicationRuntime<P, R>
implements Closeable {
    private final Name name;
    private final Injector injectorProvider;
    private final Logger log;
    private final ResourceResolver resourceResolver;
    private final AssetServer assetServer;
    private final ModuleRuntime<?> moduleLifeCycle;
    private ApplicationDescriptor descriptor;
    private AssetManager assetManager;
    private InjectionContext<?, ?> injectionContext;
    private Application application;
    private ClassLoader classLoader;
    private final RunMode runMode;

    public ApplicationRuntime(Logger log, RunMode runMode, ModuleRuntime<?> moduleLifeCycle, Injector injectorProvider, Name name, AssetServer assetServer, ResourceResolver resourceResolver) {
        this.log = log;
        this.moduleLifeCycle = moduleLifeCycle;
        this.injectorProvider = injectorProvider;
        this.name = name;
        this.assetServer = assetServer;
        this.resourceResolver = resourceResolver;
        this.runMode = runMode;
    }

    public Name getName() {
        return this.name;
    }

    public Application getApplication() {
        return this.application != null ? this.application : null;
    }

    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    public <T> T resolveBean(Class<T> beanType) {
        return this.injectionContext.resolveInstance(beanType);
    }

    public <T> Iterable<T> resolveBeans(Class<T> beanType) {
        return this.injectionContext.resolveInstances(beanType);
    }

    public synchronized Completion<Boolean> refresh() {
        if (this.application != null && this.classLoader != this.moduleLifeCycle.getClassLoader()) {
            this.stop();
        }
        if (this.application == null) {
            try {
                this.start();
                return Completion.completed(true);
            }
            catch (Exception e) {
                return Completion.failed(e);
            }
        }
        return Completion.completed(false);
    }

    protected final void start() throws Exception {
        ReadFileSystem<?> classes = this.moduleLifeCycle.getClasses();
        ApplicationDescriptor descriptor = ApplicationDescriptor.create(this.moduleLifeCycle.getClassLoader(), this.name.toString());
        Injector injector = this.injectorProvider.get();
        injector.addFileSystem(classes);
        injector.setClassLoader(this.moduleLifeCycle.getClassLoader());
        this.log.info("Starting " + descriptor.getName());
        Application application = new Application(injector, descriptor, this.resourceResolver);
        application.start();
        InjectionContext<?, ?> injectionContext = application.getInjectionContext();
        AssetService assetPlugin = injectionContext.get(AssetService.class).get();
        if (this.assetServer != null) {
            this.assetServer.register(application, this.runMode.getCacheAssets());
        }
        this.injectionContext = injectionContext;
        this.assetManager = assetPlugin.getAssetManager();
        this.descriptor = descriptor;
        this.application = application;
        this.classLoader = this.moduleLifeCycle.getClassLoader();
        try (BeanLifeCycle<Application> lf = injectionContext.get(Application.class);){
            lf.get();
        }
    }

    void stop() {
        if (this.assetServer != null) {
            this.assetServer.unregister(this.application);
        }
        Tools.safeClose(this.injectionContext);
        this.application = null;
        this.injectionContext = null;
        this.assetManager = null;
        this.descriptor = null;
        this.classLoader = null;
    }

    @Override
    public void close() {
        this.stop();
    }
}

