/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.nio.charset.Charset;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletConfig;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.portlet.PortletClientContext;
import juzu.impl.bridge.spi.portlet.PortletMimeBridge;
import juzu.io.OutputStream;
import juzu.io.Stream;
import juzu.request.ClientContext;
import juzu.request.Phase;

public class PortletResourceBridge
extends PortletMimeBridge<ResourceRequest, ResourceResponse> {
    private final PortletClientContext clientContext;

    public PortletResourceBridge(Bridge bridge, ResourceRequest request, ResourceResponse response, PortletConfig config) {
        super(bridge, Phase.RESOURCE, request, response, config);
        this.clientContext = new PortletClientContext((ClientDataRequest)request);
    }

    @Override
    public Stream createStream(String mimeType, Charset charset) throws IOException {
        if (mimeType != null) {
            ((ResourceResponse)this.resp).setContentType(mimeType);
        }
        if (charset == null) {
            charset = this.bridge.getConfig().requestEncoding;
        } else {
            ((ResourceResponse)this.resp).setCharacterEncoding(charset.name());
        }
        return OutputStream.create(charset, ((ResourceResponse)this.resp).getPortletOutputStream());
    }

    @Override
    public ClientContext getClientContext() {
        return this.clientContext;
    }
}

