/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.io.Serializable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import juzu.impl.common.Name;
import juzu.impl.compiler.ElementHandle;

public class AnnotationKey
implements Serializable {
    final ElementHandle<?> element;
    final Name type;

    public AnnotationKey(Element element, AnnotationMirror mirror) {
        this.element = ElementHandle.create(element);
        this.type = Name.parse(((TypeElement)mirror.getAnnotationType().asElement()).getQualifiedName().toString());
    }

    public AnnotationKey(Element element, Name type) {
        this.element = ElementHandle.create(element);
        this.type = type;
    }

    public AnnotationKey(ElementHandle<?> element, Name type) {
        this.element = element;
        this.type = type;
    }

    public ElementHandle<?> getElement() {
        return this.element;
    }

    public Name getType() {
        return this.type;
    }

    public int hashCode() {
        return this.element.hashCode() ^ this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AnnotationKey) {
            AnnotationKey that = (AnnotationKey)obj;
            return this.element.equals(that.element) && this.type.equals(that.type);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[annotated=" + this.element + ",type=" + this.type + "]";
    }
}

