/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import juzu.impl.plugin.controller.ControllerResolver;
import juzu.impl.plugin.controller.metamodel.ControllerMetaModel;
import juzu.impl.plugin.controller.metamodel.ControllersMetaModel;
import juzu.impl.plugin.controller.metamodel.HandlerMetaModel;
import juzu.request.Phase;

class ControllerMetaModelResolver
extends ControllerResolver<HandlerMetaModel> {
    private final ControllersMetaModel controllers;
    private final HandlerMetaModel[] methods;
    private final int size;

    ControllerMetaModelResolver(ControllersMetaModel controllers) throws NullPointerException {
        int size = 0;
        ArrayList<HandlerMetaModel> methods = new ArrayList<HandlerMetaModel>();
        for (ControllerMetaModel controller : controllers.getChildren(ControllerMetaModel.class)) {
            ++size;
            for (HandlerMetaModel method : controller.getHandlers()) {
                methods.add(method);
            }
        }
        this.controllers = controllers;
        this.methods = methods.toArray(new HandlerMetaModel[methods.size()]);
        this.size = size;
    }

    public HandlerMetaModel[] getHandlers() {
        return this.methods;
    }

    @Override
    public String getId(HandlerMetaModel method) {
        return method.getId();
    }

    @Override
    public Phase getPhase(HandlerMetaModel method) {
        return method.getPhase();
    }

    @Override
    public String getName(HandlerMetaModel method) {
        return method.getName();
    }

    @Override
    public boolean isDefault(HandlerMetaModel method) {
        return method.getController().getHandle().getName().equals(this.controllers.defaultController) || this.size < 2;
    }

    @Override
    public Collection<String> getParameterNames(HandlerMetaModel method) {
        return method.getParameterNames();
    }
}

