/*
 * Copyright 2013 eXo Platform SAS
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package juzu.impl.plugin;

import juzu.impl.inject.BeanDescriptor;

import java.util.Collections;

/**
 * Base plugin descriptor class.
 *
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 */
public class ServiceDescriptor {

  /** . */
  private final Iterable<BeanDescriptor> beans;

  public ServiceDescriptor(Iterable<BeanDescriptor> beans) {
    this.beans = beans;
  }

  public ServiceDescriptor() {
    this(Collections.<BeanDescriptor>emptyList());
  }

  /**
   * Returns the list of bean to install.
   *
   * @return the list of bean ot install
   */
  public Iterable<BeanDescriptor> getBeans() {
    return beans;
  }
}
