/*
 * Copyright 2013 eXo Platform SAS
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package juzu.plugin.asset;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import juzu.impl.asset.NormalizeJSReader;
import juzu.impl.common.Tools;
import juzu.io.UndeclaredIOException;

/**
 * @author Julien Viet
 */
// tag::class[]
public class NormalizeJSMinifier implements Minifier {

  @Override
  public InputStream minify(String name, String type, InputStream stream) throws IOException {
    if (type.equals("script")) {
      NormalizeJSReader reader = new NormalizeJSReader(new InputStreamReader(stream));
      String s = Tools.read(reader);
      return new ByteArrayInputStream(s.getBytes());
    } else {
      throw new IOException("Can only process scripts and not " + type + " asset");
    }
  }
}
// end::class[]