/*
 * Decompiled with CFR 0.152.
 */
package juzu;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.impl.common.Formatting;
import juzu.io.Chunk;
import juzu.io.ChunkBuffer;
import juzu.io.Stream;
import juzu.io.Streamable;
import juzu.io.UndeclaredIOException;
import juzu.request.Dispatch;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class Response {
    protected final PropertyMap properties;

    protected Response() {
        this.properties = new PropertyMap();
    }

    protected Response(PropertyMap properties) {
        this.properties = properties;
    }

    public <T> Response with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
        if (propertyType == null) {
            throw new NullPointerException("No null property type allowed");
        }
        this.properties.addValue(propertyType, propertyValue);
        return this;
    }

    public <T> Response without(PropertyType<T> propertyType) throws NullPointerException {
        return this.with(propertyType, null);
    }

    public Response with(PropertyType<Boolean> propertyType) throws NullPointerException {
        return this.with(propertyType, true);
    }

    public Response withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
        return this.with(propertyType, false);
    }

    public final PropertyMap getProperties() {
        return this.properties;
    }

    public Response withHeader(String name, String ... value) {
        return this.with(PropertyType.HEADER, new AbstractMap.SimpleEntry<String, String[]>(name, value));
    }

    public static Redirect redirect(String location) {
        return new Redirect(location);
    }

    public static Status status(int code) {
        return new Status(code);
    }

    public static Status ok() {
        return Response.status(200);
    }

    public static Status notFound() {
        return Response.status(404);
    }

    public static Content ok(InputStream content) {
        return Response.content(200, content);
    }

    public static Content ok(byte[] content) {
        return Response.content(200, content);
    }

    public static Content ok(Readable content) {
        return Response.content(200, content);
    }

    public static Content ok(CharSequence content) {
        return Response.content(200, content);
    }

    public static Content notFound(byte[] content) {
        return Response.content(404, content);
    }

    public static Content notFound(InputStream content) {
        return Response.content(404, content);
    }

    public static Content notFound(Readable content) {
        return Response.content(404, content);
    }

    public static Content notFound(CharSequence content) {
        return Response.content(404, content);
    }

    public static Content content(int code, byte[] content) {
        return Response.content(code, new ChunkBuffer().append(Chunk.create(content)).close());
    }

    public static Content content(int code, InputStream content) {
        return Response.content(code, new ChunkBuffer().append(Chunk.create(content)).close());
    }

    public static Content content(int code, Readable content) {
        return Response.content(code, new ChunkBuffer().append(Chunk.create(content)).close());
    }

    public static Content content(int code, CharSequence content) {
        return Response.content(code, new ChunkBuffer().append(Chunk.create(content)).close());
    }

    public static Content content(int code, Streamable content) {
        return new Content(code, content);
    }

    public static Error error(Throwable t) {
        return new Error(t);
    }

    public static Error error(String msg) {
        return new Error(msg);
    }

    public static class Error
    extends Response {
        private final Throwable cause;
        private final String message;

        public Error(Throwable cause) {
            this(null, cause);
        }

        public Error(String message) {
            this(message, null);
        }

        private Error(String message, Throwable cause) {
            this.cause = cause;
            this.message = message;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public String getMessage() {
            return this.message;
        }

        public String getHtmlMessage() {
            return this.message;
        }

        protected int getStatus() {
            return 500;
        }

        public Status asStatus(boolean verbose) {
            Status response = Response.status(this.getStatus());
            if (verbose) {
                StringBuilder buffer = new StringBuilder();
                Formatting.renderStyleSheet(buffer);
                buffer.append("<div class=\"juzu\">");
                buffer.append("<h1>Oups something went wrong</h1>");
                Throwable c = this.getCause();
                if (c != null) {
                    Formatting.renderThrowable(null, buffer, c);
                } else {
                    String m = this.getHtmlMessage();
                    buffer.append(m);
                }
                buffer.append("</div>");
                response = response.content(buffer).withMimeType("text/html");
            }
            return response;
        }

        public String toString() {
            return "Response.Error[" + (this.cause != null ? this.cause.getMessage() : "") + "]";
        }

        public static class Forbidden
        extends Error {
            public Forbidden(Throwable cause) {
                super(cause);
            }

            public Forbidden(String message) {
                super(message);
            }

            public Forbidden(String message, Throwable cause) {
                super(message, cause);
            }

            @Override
            protected int getStatus() {
                return 403;
            }
        }
    }

    public static class Content
    extends Body {
        public Content(int status, PropertyMap properties, Streamable streamable) {
            super(status, properties, streamable);
        }

        public Content(int status, Streamable streamable) {
            super(status, streamable);
        }

        public Content(PropertyMap properties, Streamable streamable) {
            super(200, properties, streamable);
        }

        public Content(Streamable streamable) {
            super(200, streamable);
        }

        @Override
        public <T> Content with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (Content)super.with((PropertyType)propertyType, (Object)propertyValue);
        }

        @Override
        public <T> Content without(PropertyType<T> propertyType) throws NullPointerException {
            return (Content)super.without((PropertyType)propertyType);
        }

        @Override
        public Content with(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Content)super.with((PropertyType)propertyType);
        }

        @Override
        public Content withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Content)super.withNo((PropertyType)propertyType);
        }

        @Override
        public Content withMimeType(String mimeType) {
            return (Content)super.withMimeType(mimeType);
        }

        @Override
        public Content withCharset(Charset charset) {
            return (Content)super.withCharset(charset);
        }

        @Override
        public Content withHeader(String name, String ... value) {
            return (Content)super.withHeader(name, value);
        }

        public String getTitle() {
            return this.properties.getValue(PropertyType.TITLE);
        }

        public Content withTitle(String title) {
            return this.with((PropertyType)PropertyType.TITLE, title);
        }

        public Content withAssets(String ... assets) throws NullPointerException {
            if (assets == null) {
                throw new NullPointerException("No null asset accepted");
            }
            for (String asset : assets) {
                this.with((PropertyType)PropertyType.ASSET, asset);
            }
            return this;
        }

        public Content withMetaTag(String name, String value) {
            this.with((PropertyType)PropertyType.META_TAG, new AbstractMap.SimpleEntry<String, String>(name, value));
            return this;
        }

        public Content withMetaHttpEquiv(String name, String value) {
            this.with((PropertyType)PropertyType.META_HTTP_EQUIV, new AbstractMap.SimpleEntry<String, String>(name, value));
            return this;
        }

        public Content withHeaderTag(String header) throws ParserConfigurationException, SAXException {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            try {
                Document doc = builder.parse(new InputSource(new StringReader(header)));
                Element elt = doc.getDocumentElement();
                return this.withHeaderTag(elt);
            }
            catch (IOException e) {
                throw new UndeclaredIOException(e);
            }
        }

        public Content withHeaderTag(Element header) {
            return this.with((PropertyType)PropertyType.HEADER_TAG, header);
        }

        public String toString() {
            return "Response.Content[]";
        }
    }

    public static class Body
    extends Status {
        private Streamable data;

        protected Body(int status, PropertyMap properties) {
            super(status, properties);
            this.data = null;
        }

        protected Body(int status, Streamable data) {
            super(status);
            this.data = data;
        }

        protected Body(int status, PropertyMap properties, Streamable data) {
            super(status, properties);
            this.data = data;
        }

        public Streamable getData() {
            return this.data;
        }

        public String getMimeType() {
            return this.properties.getValue(PropertyType.MIME_TYPE);
        }

        public Charset getCharset() {
            return this.properties.getValue(PropertyType.ENCODING);
        }

        public Body withCharset(Charset charset) {
            return this.with((PropertyType)PropertyType.ENCODING, charset);
        }

        public Body withMimeType(String mimeType) {
            return this.with((PropertyType)PropertyType.MIME_TYPE, mimeType);
        }

        @Override
        public Body withHeader(String name, String ... value) {
            return (Body)super.withHeader(name, value);
        }

        @Override
        public <T> Body with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (Body)super.with((PropertyType)propertyType, (Object)propertyValue);
        }

        @Override
        public <T> Body without(PropertyType<T> propertyType) throws NullPointerException {
            return (Body)super.without((PropertyType)propertyType);
        }

        @Override
        public Body with(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Body)super.with((PropertyType)propertyType);
        }

        @Override
        public Body withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Body)super.withNo((PropertyType)propertyType);
        }
    }

    public static class Status
    extends Response {
        private int code;

        public Status(int code) {
            this.code = code;
        }

        public Status(int code, PropertyMap properties) {
            super(properties);
            this.code = code;
        }

        public final int getCode() {
            return this.code;
        }

        public Body body(Streamable s) {
            return new Body(this.code, this.properties, s);
        }

        public Body body(ChunkBuffer s) {
            return new Body(this.code, this.properties, s);
        }

        public Body body(CharSequence s) {
            return this.body(new ChunkBuffer().append(Chunk.create(s)).close());
        }

        public Body body(byte[] s) {
            return this.body(new ChunkBuffer().append(Chunk.create(s)).close());
        }

        public Body body(InputStream s) {
            return this.body(new ChunkBuffer().append(Chunk.create(s)).close());
        }

        public Content content(Streamable s) {
            return new Content(this.code, this.properties, s);
        }

        public Content content(CharSequence s) {
            return this.content(new ChunkBuffer().append(Chunk.create(s)).close());
        }

        public Content content(byte[] s) {
            return this.content(new ChunkBuffer().append(Chunk.create(s)).close());
        }

        public Content content(InputStream s) {
            return this.content(new ChunkBuffer().append(Chunk.create(s)).close());
        }

        @Override
        public Status withHeader(String name, String ... value) {
            return (Status)super.withHeader(name, value);
        }

        @Override
        public Status withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Status)super.withNo(propertyType);
        }

        @Override
        public Status with(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Status)super.with(propertyType);
        }

        @Override
        public <T> Status without(PropertyType<T> propertyType) throws NullPointerException {
            return (Status)super.without(propertyType);
        }

        @Override
        public <T> Status with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (Status)super.with(propertyType, propertyValue);
        }

        public Streamable streamable() {
            return new Streamable(){

                @Override
                public void send(Stream stream) throws IllegalStateException {
                    for (PropertyType<?> propertyType : Status.this.properties) {
                        Iterable<?> values = Status.this.properties.getValues(propertyType);
                        if (values == null) continue;
                        for (Object o : values) {
                            stream.provide(new Chunk.Property(o, propertyType));
                        }
                    }
                    if (Status.this instanceof Body) {
                        ((Body)Status.this).getData().send(stream);
                    } else {
                        stream.close(null);
                    }
                }
            };
        }
    }

    public static class Redirect
    extends Response {
        private final String location;

        public Redirect(String location) {
            this.location = location;
        }

        public String getLocation() {
            return this.location;
        }

        @Override
        public <T> Redirect with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (Redirect)super.with(propertyType, propertyValue);
        }

        @Override
        public Redirect withHeader(String name, String ... value) {
            return (Redirect)super.withHeader(name, value);
        }

        @Override
        public <T> Redirect without(PropertyType<T> propertyType) throws NullPointerException {
            return (Redirect)super.without(propertyType);
        }

        @Override
        public Redirect with(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Redirect)super.with(propertyType);
        }

        @Override
        public Redirect withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (Redirect)super.withNo(propertyType);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Redirect) {
                Redirect that = (Redirect)obj;
                return this.location.equals(that.location);
            }
            return false;
        }

        public String toString() {
            return "Response.Redirect[location" + this.location + "]";
        }
    }

    public static abstract class View
    extends Response
    implements Dispatch {
        @Override
        public <T> View with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (View)super.with(propertyType, propertyValue);
        }

        @Override
        public View withHeader(String name, String ... value) {
            return (View)super.withHeader(name, value);
        }

        @Override
        public <T> View without(PropertyType<T> propertyType) throws NullPointerException {
            return (View)super.without(propertyType);
        }

        @Override
        public View with(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (View)super.with(propertyType);
        }

        @Override
        public View withNo(PropertyType<Boolean> propertyType) throws NullPointerException {
            return (View)super.withNo(propertyType);
        }

        public abstract boolean equals(Object var1);
    }
}

