/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.asset;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import juzu.impl.asset.Asset;
import juzu.impl.asset.AssetDeployment;
import juzu.impl.asset.AssetGraph;
import juzu.impl.asset.AssetNode;
import juzu.impl.asset.AssetResource;
import juzu.impl.common.Tools;
import juzu.impl.plugin.application.Application;
import juzu.impl.resource.ResourceResolver;

public class AssetManager {
    private HashMap<String, AssetNode> assets = new HashMap();
    private AssetGraph graph = new AssetGraph();
    protected final String prefix;
    protected final ResourceResolver applicationResolver;

    @Inject
    public AssetManager(Application application) {
        this.prefix = "/" + application.getDescriptor().getPackageName().replace('.', '/') + "/assets/";
        this.applicationResolver = application;
    }

    AssetManager(String prefix, ResourceResolver applicationResolver) {
        this.prefix = prefix;
        this.applicationResolver = applicationResolver;
    }

    public AssetDeployment createDeployment() {
        return new AssetDeployment(this);
    }

    boolean deploy(AssetDeployment deployment) {
        AssetGraph graphClone = new AssetGraph(this.graph);
        HashMap<String, AssetNode> assetsClone = new HashMap<String, AssetNode>(this.assets);
        for (AssetNode asset : deployment.assets) {
            if (!assetsClone.keySet().contains(asset.id)) {
                for (AssetNode deployed : assetsClone.values()) {
                    if (deployed.iDependOn.contains(asset.id) && !graphClone.register(asset.id, deployed.id)) {
                        return false;
                    }
                    if (!asset.iDependOn.contains(deployed.id) || graphClone.register(deployed.id, asset.id)) continue;
                    return false;
                }
                assetsClone.put(asset.id, asset);
                continue;
            }
            return false;
        }
        this.assets = assetsClone;
        this.graph = graphClone;
        return true;
    }

    void undeploy(AssetDeployment deployment) {
        for (AssetNode asset : deployment.assets) {
            for (AssetNode deployed : this.assets.values()) {
                if (deployed.iDependOn.contains(asset.id)) {
                    this.graph.unregister(asset.id, deployed.id);
                }
                if (!asset.iDependOn.contains(deployed.id)) continue;
                this.graph.unregister(deployed.id, asset.id);
            }
            this.assets.remove(asset.id);
        }
    }

    public AssetResource resolveApplicationAssetResource(String path) {
        for (AssetNode asset : this.assets.values()) {
            if (!asset.value.equals(path) || asset.resource == null) continue;
            Integer maxAge = asset.asset.getMaxAge();
            return new AssetResource(asset.resource, maxAge);
        }
        if (path.startsWith(this.prefix)) {
            URL resolved = this.applicationResolver.resolve(path);
            return new AssetResource(resolved, null);
        }
        return null;
    }

    public Map<String, Asset> getAssets(String type) {
        Map<String, Asset> ret = Collections.emptyMap();
        for (AssetNode node : this.assets.values()) {
            if (!node.asset.getType().equals(type)) continue;
            if (ret.isEmpty()) {
                ret = new HashMap<String, Asset>();
            }
            ret.put(node.id, node.asset);
        }
        return ret;
    }

    public Asset getAsset(String id) throws NullPointerException {
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        AssetNode node = this.assets.get(id);
        return node != null ? node.asset : null;
    }

    public Iterable<Asset> resolveAssets(Iterable<String> ids) throws NullPointerException, IllegalArgumentException {
        if (ids == null) {
            throw new NullPointerException("No null asset ids accepted");
        }
        LinkedHashMap<String, HashSet<String>> sub = new LinkedHashMap<String, HashSet<String>>();
        LinkedList<String> queue = Tools.addAll(new LinkedList(), ids);
        while (!queue.isEmpty()) {
            String id = (String)queue.removeFirst();
            AssetNode asset = this.assets.get(id);
            if (asset != null) {
                sub.put(asset.id, new HashSet<String>(asset.iDependOn));
                for (String string : asset.iDependOn) {
                    if (sub.containsKey(string)) continue;
                    queue.addLast(string);
                }
                continue;
            }
            throw new IllegalArgumentException("Cannot resolve asset " + id);
        }
        LinkedList<Asset> resolved = new LinkedList<Asset>();
        while (sub.size() > 0) {
            boolean found = false;
            Iterator i = sub.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (!((HashSet)entry.getValue()).isEmpty()) continue;
                i.remove();
                AssetNode assetNode = this.assets.get(entry.getKey());
                resolved.add(assetNode.asset);
                Set dependencies = (Set)this.graph.get(assetNode.id);
                if (dependencies != null) {
                    for (String dependency : dependencies) {
                        HashSet foo = (HashSet)sub.get(dependency);
                        if (foo == null) continue;
                        foo.remove(entry.getKey());
                    }
                }
                found = true;
                break;
            }
            if (found) continue;
            StringBuilder sb = new StringBuilder("Cannot satisfy asset dependencies:\n");
            for (Map.Entry entry : sub.entrySet()) {
                sb.append((String)entry.getKey()).append(" -> ").append(entry.getValue());
            }
            throw new IllegalArgumentException(sb.toString());
        }
        return resolved;
    }
}

