/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import juzu.impl.common.AppendableWriter;
import juzu.impl.common.Tools;
import juzu.impl.compiler.CompilationError;
import juzu.io.UndeclaredIOException;

public class Formatting {
    public static void renderStyleSheet(StringBuilder buffer) {
        try {
            Formatting.renderStyleSheet((Appendable)buffer);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public static void renderStyleSheet(Appendable appendable) throws IOException {
        URL cssURL = Formatting.class.getResource("juzu.css");
        String css = Tools.read(cssURL);
        css = css.replace("\"", "\\\"");
        css = css.replace("'", "\\'");
        css = css.replace("\n", "\\n");
        appendable.append("<script type='text/javascript'>\n");
        appendable.append("var styleElement = document.createElement('style');\n");
        appendable.append("var css = '");
        appendable.append(css);
        appendable.append("';\n");
        appendable.append("styleElement.type = 'text/css';\n");
        appendable.append("if (styleElement.styleSheet) {;\n");
        appendable.append("styleElement.styleSheet.cssText = css;\n");
        appendable.append("} else {\n");
        appendable.append("styleElement.appendChild(document.createTextNode(css));\n");
        appendable.append("}\n");
        appendable.append("document.getElementsByTagName(\"head\")[0].appendChild(styleElement);\n");
        appendable.append("</script>\n");
    }

    public static void renderThrowable(Class<?> stop, StringBuilder buffer, Throwable t) {
        try {
            Formatting.renderThrowable(stop, (Appendable)buffer, t);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public static void renderThrowable(Class<?> stop, Appendable appendable, Throwable t) throws IOException {
        StackTraceElement[] trace;
        int size = 0;
        for (StackTraceElement element : trace = t.getStackTrace()) {
            if (stop != null && element.getClassName().equals(stop.getName())) break;
            ++size;
        }
        StackTraceElement[] ourTrace = new StackTraceElement[size];
        System.arraycopy(trace, 0, ourTrace, 0, ourTrace.length);
        t.setStackTrace(ourTrace);
        final AtomicBoolean open = new AtomicBoolean(false);
        PrintWriter formatter = new PrintWriter((Writer)new AppendableWriter(appendable)){

            @Override
            public void println(Object x) {
                if (open.get()) {
                    super.append("</ul></div>");
                }
                super.append("<p>");
                super.append(String.valueOf(x));
                super.append("</p>");
                open.set(false);
            }

            @Override
            public void println(String x) {
                if (!open.get()) {
                    super.append("<div class=\"code\"><ul>");
                    open.set(true);
                }
                super.append("<li><p>");
                super.append(x);
                super.append("</p></li>");
            }

            @Override
            public void println() {
            }
        };
        appendable.append("<section>");
        t.printStackTrace(formatter);
        if (open.get()) {
            appendable.append("</ul></div>");
        }
        appendable.append("</section>");
    }

    public static void renderErrors(StringBuilder buffer, Iterable<CompilationError> errors) {
        try {
            Formatting.renderErrors((Appendable)buffer, errors);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public static void renderErrors(Appendable appendable, Iterable<CompilationError> errors) throws IOException {
        Formatting.renderStyleSheet(appendable);
        for (CompilationError error : errors) {
            appendable.append("<section>");
            appendable.append("<p>").append(error.getMessage()).append("</p>");
            File source = error.getSourceFile();
            if (source != null) {
                int line = error.getLocation().getLine();
                int from = line - 2;
                int to = line + 3;
                BufferedReader reader = new BufferedReader(new FileReader(source));
                int count = 1;
                appendable.append("<div class=\"code\"><ol start=\"").append(String.valueOf(from)).append("\">");
                String s = reader.readLine();
                while (s != null) {
                    if (count >= from && count < to) {
                        if (count == line) {
                            appendable.append("<li><p class=\"error\">").append(s).append("</p></li>");
                        } else {
                            appendable.append("<li><p>").append(s).append("</p></li>");
                        }
                    }
                    ++count;
                    s = reader.readLine();
                }
                appendable.append("</ol></div>");
            }
            appendable.append("</section>");
        }
    }
}

