/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import juzu.impl.common.Spliterator;
import juzu.impl.common.Tools;

public final class MethodHandle
implements Iterable<String> {
    private static final String[] EMPTY_STRINGS = new String[0];
    private final String type;
    private final String name;
    private final String[] parameters;
    private String toString;

    public static MethodHandle parse(String s) throws NullPointerException, IllegalArgumentException {
        int method = s.indexOf(35);
        if (method == -1) {
            throw new IllegalArgumentException("Invalid method handle " + s);
        }
        int leftParenthesis = s.indexOf(40, method + 1);
        if (leftParenthesis == -1 || leftParenthesis > s.length() - 2) {
            throw new IllegalArgumentException("Invalid method handle " + s);
        }
        if (s.charAt(s.length() - 1) != ')') {
            throw new IllegalArgumentException("Invalid method handle " + s);
        }
        String type = s.substring(0, method);
        String name = s.substring(method + 1, leftParenthesis);
        if (s.length() - leftParenthesis == 2) {
            return new MethodHandle(type, name);
        }
        String[] list = EMPTY_STRINGS;
        for (String parameter : Spliterator.split(s, leftParenthesis + 1, s.length() - 1, ',', new ArrayList())) {
            if (parameter.length() == 0) {
                throw new IllegalArgumentException();
            }
            list = Tools.appendTo(list, parameter);
        }
        return new MethodHandle(type, name, list);
    }

    public MethodHandle(Method method) throws NullPointerException {
        if (method == null) {
            throw new NullPointerException("No null method accepted");
        }
        Type[] parameterTypes = method.getGenericParameterTypes();
        String[] parameters = new String[parameterTypes.length];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parameters.length; ++i) {
            this.format(parameterTypes[i], sb);
            parameters[i] = sb.toString();
            sb.setLength(0);
        }
        this.type = method.getDeclaringClass().getName();
        this.name = method.getName();
        this.parameters = (String[])parameters.clone();
        this.toString = null;
    }

    private void format(Type type, StringBuilder sb) {
        if (type instanceof Class) {
            Class classType = (Class)type;
            if (classType.isArray()) {
                this.format(classType.getComponentType(), sb);
                sb.append("[]");
            } else {
                sb.append(classType.getName());
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            this.format(parameterizedType.getRawType(), sb);
            sb.append('<');
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeArguments.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                this.format(typeArguments[i], sb);
            }
            sb.append('>');
        } else if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            this.format(arrayType.getGenericComponentType(), sb);
            sb.append("[]");
        } else {
            throw new UnsupportedOperationException("todo " + type);
        }
    }

    public MethodHandle(String type, String name) {
        this.type = type;
        this.name = name;
        this.parameters = EMPTY_STRINGS;
    }

    public MethodHandle(String type, String name, String ... parameters) {
        this.type = type;
        this.name = name;
        this.parameters = parameters.length == 0 ? parameters : (String[])parameters.clone();
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getParameterSize() {
        return this.parameters.length;
    }

    public String getParameterAt(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.parameters.length) {
            throw new IndexOutOfBoundsException("Bad index " + index);
        }
        return this.parameters[index];
    }

    @Override
    public Iterator<String> iterator() {
        return Tools.iterator(this.parameters);
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.name.hashCode() ^ Arrays.hashCode(this.parameters);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MethodHandle) {
            MethodHandle that = (MethodHandle)obj;
            return this.type.equals(that.type) && this.name.equals(that.name) && Arrays.equals(this.parameters, that.parameters);
        }
        return false;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = Tools.join(new StringBuilder().append(this.type).append('#').append(this.name).append('('), ',', this.parameters).append(')').toString();
        }
        return this.toString;
    }
}

