/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.asset;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import juzu.PropertyType;
import juzu.Response;
import juzu.asset.AssetLocation;
import juzu.impl.asset.AssetDeployment;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetMetaData;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.io.StreamableDecorator;
import juzu.impl.plugin.ServiceContext;
import juzu.impl.plugin.ServiceDescriptor;
import juzu.impl.plugin.application.ApplicationService;
import juzu.impl.plugin.asset.AssetDescriptor;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.impl.request.Stage;
import juzu.io.Chunk;
import juzu.io.Stream;
import juzu.io.Streamable;
import juzu.plugin.asset.Assets;
import juzu.request.Phase;

public class AssetService
extends ApplicationService
implements RequestFilter<Stage.Unmarshalling> {
    private LinkedHashMap<String, Chunk.Property<String>> assets;
    private AssetDescriptor descriptor;
    private ServiceContext context;
    private String assetsPath;
    @Inject
    AssetManager assetManager;

    public AssetService() {
        super("asset");
    }

    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    public String getAssetsPath() {
        return this.assetsPath;
    }

    @Override
    public ServiceDescriptor init(ServiceContext context) throws Exception {
        String assetsPath;
        List<AssetMetaData> assets;
        JSON config = context.getConfig();
        if (config != null) {
            String packageName = config.getString("package");
            assets = this.load(packageName, config.getJSON("assets"));
            assetsPath = "/" + Name.parse(this.application.getPackageName()).append(packageName).toString().replace('.', '/') + "/";
        } else {
            assets = Collections.emptyList();
            assetsPath = null;
        }
        this.descriptor = new AssetDescriptor(assets);
        this.context = context;
        this.assetsPath = assetsPath;
        return this.descriptor;
    }

    private List<AssetMetaData> load(String packageName, JSON assets) throws Exception {
        List<AssetMetaData> abc = Collections.emptyList();
        if (assets != null && assets.getSize() > 0) {
            abc = new ArrayList<AssetMetaData>();
            for (String id : assets.names()) {
                JSON asset = assets.getJSON(id);
                AssetLocation location = AssetLocation.safeValueOf(asset.getString("location"));
                if (location == null) {
                    location = AssetLocation.APPLICATION;
                }
                String type = asset.getString("type");
                String value = asset.getString("value");
                if (location == AssetLocation.APPLICATION && !value.startsWith("/")) {
                    value = "/" + this.application.getPackageName().replace('.', '/') + "/" + packageName.replace('.', '/') + "/" + value;
                }
                String minified = asset.getString("minified");
                if (location == AssetLocation.APPLICATION && minified != null && !minified.startsWith("/")) {
                    minified = "/" + this.application.getPackageName().replace('.', '/') + "/" + packageName.replace('.', '/') + "/" + minified;
                }
                Boolean header = asset.getBoolean("header");
                Integer maxAge = asset.getInteger("max-age");
                AssetMetaData descriptor = new AssetMetaData(id, type, location, value, header, minified, maxAge, asset.getArray("depends", String.class));
                abc.add(descriptor);
            }
        }
        return abc;
    }

    @PostConstruct
    public void start() throws Exception {
        this.assets = this.process(this.descriptor.getAssets());
    }

    public URL resolve(AssetLocation location, String path) {
        switch (location) {
            case APPLICATION: {
                return this.context.getApplicationResolver().resolve(path);
            }
            case SERVER: {
                return this.context.getServerResolver().resolve(path);
            }
        }
        return null;
    }

    private LinkedHashMap<String, Chunk.Property<String>> process(List<AssetMetaData> data) throws Exception {
        LinkedHashMap<String, Chunk.Property<String>> assets = new LinkedHashMap<String, Chunk.Property<String>>();
        AssetDeployment deployment = this.assetManager.createDeployment();
        for (AssetMetaData script : data) {
            String[] a = new String[]{script.getValue(), script.getMinified()};
            URL[] resources = new URL[2];
            for (int i = 0; i < a.length; ++i) {
                URL resource;
                String value = a[i];
                if (value != null) {
                    URL url;
                    AssetLocation location = script.getLocation();
                    if (location == AssetLocation.APPLICATION) {
                        url = this.resolve(AssetLocation.APPLICATION, value);
                        if (url == null) {
                            throw new Exception("Could not resolve application  " + value);
                        }
                        resource = url;
                    } else if (location == AssetLocation.SERVER) {
                        if (!value.startsWith("/") && (url = this.resolve(AssetLocation.SERVER, "/" + value)) == null) {
                            throw new Exception("Could not resolve server asset " + value);
                        }
                        resource = null;
                    } else {
                        resource = null;
                    }
                } else {
                    resource = null;
                }
                resources[i] = resource;
            }
            deployment.addAsset(script.getId(), script.getType(), script.getLocation(), a[0], script.getHeader(), a[1], script.getMaxAge(), resources[0], script.getDependencies());
            assets.put(script.getId(), new Chunk.Property<String>(script.getId(), PropertyType.ASSET));
        }
        deployment.deploy();
        return assets;
    }

    private Collection<Chunk.Property<String>> foo(AnnotatedElement elt, List<Chunk.Property<String>> bar) {
        Assets decl = elt.getAnnotation(Assets.class);
        if (decl != null) {
            String[] value;
            for (String s : value = decl.value()) {
                if (s.equals("*")) {
                    return this.assets.values();
                }
                Chunk.Property<String> p = this.assets.get(s);
                if (p == null) {
                    throw new UnsupportedOperationException("handle me gracefully");
                }
                if (bar.size() == 0) {
                    bar = new ArrayList<Chunk.Property<String>>();
                }
                bar.add(p);
            }
        }
        if (elt instanceof Method) {
            Method methodElt = (Method)elt;
            if (decl == null) {
                for (Class<?> current = methodElt.getDeclaringClass().getSuperclass(); current != null; current = current.getSuperclass()) {
                    try {
                        methodElt = current.getDeclaredMethod(methodElt.getName(), methodElt.getParameterTypes());
                        return this.foo(methodElt, bar);
                    }
                    catch (NoSuchMethodException ignore) {
                        continue;
                    }
                }
            }
            return this.foo(methodElt.getDeclaringClass(), bar);
        }
        if (elt instanceof Class) {
            Class classElt = (Class)elt;
            String pkgName = classElt.getSimpleName().equals("package-info") ? Tools.parentPackageOf(Tools.parentPackageOf(classElt.getName())) : Tools.parentPackageOf(classElt.getName());
            while (pkgName != null) {
                Class<?> currentPackage = Tools.getPackageClass(Thread.currentThread().getContextClassLoader(), pkgName);
                if (currentPackage != null) {
                    return this.foo(currentPackage, bar);
                }
                pkgName = Tools.parentPackageOf(pkgName);
            }
            return bar;
        }
        return bar;
    }

    @Override
    public Class<Stage.Unmarshalling> getStageType() {
        return Stage.Unmarshalling.class;
    }

    @Override
    public Response handle(Stage.Unmarshalling argument) {
        Response result = argument.invoke();
        Request request = argument.getRequest();
        if (request.getPhase() == Phase.VIEW && result instanceof Response.Content) {
            final Collection<Chunk.Property<String>> bar = this.foo(request.getHandler().getMethod(), Collections.emptyList());
            Response.Status status = (Response.Status)result;
            if (bar.size() > 0) {
                status = new Response.Content(status.getCode(), (Streamable)new StreamableDecorator(status.streamable()){

                    @Override
                    protected void sendHeader(Stream consumer) {
                        for (Chunk.Property asset : bar) {
                            consumer.provide(asset);
                        }
                    }
                });
                result = status;
            }
        }
        return result;
    }
}

