/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.asset;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.tools.FileObject;
import juzu.impl.asset.AssetServer;
import juzu.impl.common.MethodInvocation;
import juzu.impl.common.MethodInvocationResolver;
import juzu.impl.common.Name;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.metamodel.Key;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.asset.Asset;
import juzu.impl.plugin.asset.AssetKey;

public class AssetsMetaModel
extends MetaModelObject
implements MethodInvocationResolver {
    public static final MessageCode UNRESOLVED_ASSET = new MessageCode("UNRESOLVED_ASSET", "The application asset %1s cannot be resolved");
    public static final Key<AssetsMetaModel> KEY = Key.of(AssetsMetaModel.class);
    private final HashMap<AssetKey, Asset> assets = new HashMap();
    private final HashMap<String, URL> resources = new HashMap();
    private final ElementHandle.Package pkg;

    public AssetsMetaModel(ElementHandle.Package pkg) {
        this.pkg = pkg;
    }

    public void addAsset(Asset asset) {
        this.assets.put(asset.key, asset);
    }

    public void removeAsset(Asset asset) {
        this.assets.remove(asset.key);
    }

    public void addResource(String path, URL resource) {
        URL existing = this.resources.get(path);
        if (existing != null) {
            throw new UnsupportedOperationException("Cannot add resource " + path + " : added " + resource + " != existing " + existing);
        }
        this.resources.put(path, resource);
    }

    public void removeResource(String path, URL resource) {
        URL existing = this.resources.get(path);
        if (!resource.equals(existing)) {
            throw new UnsupportedOperationException("Resource conflict for resource " + path + " : removed " + resource + " not matched by existing " + existing);
        }
        this.resources.remove(path);
    }

    public URL resolveResource(String path) throws ProcessingException {
        boolean relative;
        ApplicationMetaModel application = (ApplicationMetaModel)this.metaModel;
        ProcessingContext context = application.getProcessingContext();
        boolean bl = relative = path.length() == 0 || path.charAt(0) != '/';
        if (relative) {
            FileObject src;
            context.info("Resolving classpath asset " + path);
            Name qn = application.getHandle().getPackageName().append("assets");
            try {
                src = context.resolveResourceFromSourcePath(this.pkg, qn, path);
            }
            catch (Exception e) {
                throw UNRESOLVED_ASSET.failure(path).initCause(e);
            }
            if (src != null) {
                URI uri = src.toUri();
                context.info("Found asset " + path + " on source path " + uri);
                try {
                    String scheme = uri.getScheme();
                    if (scheme == null) {
                        uri = new URI("file:" + uri);
                    }
                    return uri.toURL();
                }
                catch (URISyntaxException e) {
                    throw UNRESOLVED_ASSET.failure(uri).initCause(e);
                }
                catch (MalformedURLException e) {
                    throw UNRESOLVED_ASSET.failure(uri).initCause(e);
                }
            }
            context.info("Could not find asset " + path + " on source path");
            return null;
        }
        return null;
    }

    public Map<String, URL> getResources() {
        return this.resources;
    }

    public Iterable<Asset> getAssets() {
        return this.assets.values();
    }

    public Iterable<Asset> getAssets(final String type) {
        return new Iterable<Asset>(){

            @Override
            public Iterator<Asset> iterator() {
                final Iterator i = AssetsMetaModel.this.assets.values().iterator();
                return new Iterator<Asset>(){
                    Asset next = null;

                    @Override
                    public boolean hasNext() {
                        while (this.next == null && i.hasNext()) {
                            Asset asset = (Asset)i.next();
                            if (!asset.type.equals(type)) continue;
                            this.next = asset;
                        }
                        return this.next != null;
                    }

                    @Override
                    public Asset next() {
                        if (this.hasNext()) {
                            Asset tmp = this.next;
                            this.next = null;
                            return tmp;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void removeAssets(String type) {
        Iterator<Asset> i = this.assets.values().iterator();
        while (i.hasNext()) {
            Asset asset = i.next();
            if (!asset.type.equals(type)) continue;
            i.remove();
        }
    }

    @Override
    public MethodInvocation resolveMethodInvocation(String typeName, String methodName, Map<String, String> parameterMap) {
        if ("Assets".equals(typeName) && methodName.equals("url")) {
            String path = parameterMap.get("path");
            if (path != null) {
                return new MethodInvocation(AssetServer.class.getName(), "renderAssetURLByPath", Collections.singletonList(path));
            }
            String id = parameterMap.get("id");
            if (id != null) {
                return new MethodInvocation(AssetServer.class.getName(), "renderAssetURLById", Collections.singletonList(id));
            }
        }
        return null;
    }
}

