/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.Scope;
import juzu.asset.AssetLocation;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.DispatchBridge;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.bridge.spi.ScopedContext;
import juzu.impl.bridge.spi.web.Handler;
import juzu.impl.bridge.spi.web.WebBridge;
import juzu.impl.bridge.spi.web.WebViewBridge;
import juzu.impl.common.Logger;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.MimeType;
import juzu.impl.common.RunMode;
import juzu.impl.common.Tools;
import juzu.impl.common.UriBuilder;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.plugin.controller.ControllerService;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.ControllerHandler;
import juzu.impl.request.Request;
import juzu.impl.router.PathParam;
import juzu.impl.router.Route;
import juzu.impl.router.RouteMatch;
import juzu.request.ApplicationContext;
import juzu.request.ClientContext;
import juzu.request.HttpContext;
import juzu.request.Phase;
import juzu.request.RequestParameter;
import juzu.request.ResponseParameter;
import juzu.request.SecurityContext;
import juzu.request.UserContext;
import juzu.request.WindowContext;

public abstract class WebRequestBridge
implements RequestBridge,
WindowContext {
    final Bridge bridge;
    final Handler handler;
    final WebBridge http;
    final Phase phase;
    final ControllerHandler<?> target;
    protected Request request;
    protected Map<String, RequestParameter> requestParameters;
    protected Response response;

    WebRequestBridge(Bridge bridge, Handler handler, WebBridge http, Phase phase, ControllerHandler<?> target, Map<String, RequestParameter> requestParameters) {
        this.requestParameters = requestParameters;
        this.bridge = bridge;
        this.target = target;
        this.handler = handler;
        this.http = http;
        this.request = null;
        this.phase = phase;
    }

    @Override
    public Charset getDefaultRequestEncoding() {
        return this.bridge.getConfig().requestEncoding;
    }

    @Override
    public Map<ContextualParameter, Object> getContextualArguments(Set<ContextualParameter> parameters) {
        return Collections.emptyMap();
    }

    @Override
    public RunMode getRunMode() {
        return this.bridge.getRunMode();
    }

    @Override
    public Phase getPhase() {
        return this.phase;
    }

    @Override
    public Logger getLogger(String name) {
        return this.http.getLogger(name);
    }

    @Override
    public Map<String, RequestParameter> getRequestArguments() {
        return this.requestParameters;
    }

    @Override
    public MethodHandle getTarget() {
        return this.target.getHandle();
    }

    @Override
    public <T> T getProperty(PropertyType<T> propertyType) {
        if (RunMode.PROPERTY.equals(propertyType)) {
            return propertyType.cast((Object)this.bridge.getRunMode());
        }
        if (InjectorProvider.PROPERTY.equals(propertyType)) {
            return propertyType.cast((Object)this.bridge.getConfig().injectorProvider);
        }
        if (PropertyType.PATH.equals(propertyType)) {
            return propertyType.cast(this.http.getRequestContext().getRequestURI());
        }
        return null;
    }

    @Override
    public final String getNamespace() {
        return "window_ns";
    }

    @Override
    public final String getId() {
        return "window_id";
    }

    @Override
    public ClientContext getClientContext() {
        return this.phase == Phase.ACTION || this.phase == Phase.RESOURCE ? this.http.getClientContext() : null;
    }

    @Override
    public final HttpContext getHttpContext() {
        return this.http.getHttpContext();
    }

    @Override
    public final WindowContext getWindowContext() {
        return this;
    }

    @Override
    public final SecurityContext getSecurityContext() {
        return this.http.getSecurityContext();
    }

    @Override
    public UserContext getUserContext() {
        return this.http.getUserContext();
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.http.getApplicationContext();
    }

    @Override
    public final ScopedContext getScopedContext(Scope scope, boolean create) {
        ScopedContext context;
        switch (scope) {
            case REQUEST: {
                context = this.http.getRequestScope(create);
                break;
            }
            case FLASH: {
                context = this.http.getFlashScope(create);
                break;
            }
            case SESSION: {
                context = this.http.getSessionScope(create);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported scope " + (Object)((Object)scope));
            }
        }
        return context;
    }

    @Override
    public final DispatchBridge createDispatch(Phase phase, final MethodHandle target, final Map<String, ResponseParameter> parameters) {
        ControllerHandler handler = this.bridge.getApplication().resolveBean(ControllerService.class).getDescriptor().getMethodByHandle(target);
        Route route = this.handler.getRoute(handler.getHandle());
        if (route == null && this.bridge.getApplication().resolveBean(ControllerService.class).getResolver().isIndex(handler)) {
            route = this.handler.getRoot();
        }
        if (route != null) {
            Map<String, String> params;
            if (parameters.isEmpty()) {
                params = Collections.emptyMap();
            } else {
                params = new HashMap<String, String>(parameters.size());
                for (ResponseParameter parameter : parameters.values()) {
                    params.put(parameter.getName(), (String)parameter.get(0));
                }
            }
            final RouteMatch match = route.matches(params);
            if (match != null) {
                return new DispatchBridge(){

                    @Override
                    public MethodHandle getTarget() {
                        return target;
                    }

                    @Override
                    public Map<String, ResponseParameter> getParameters() {
                        return parameters;
                    }

                    @Override
                    public <T> String checkPropertyValidity(PropertyType<T> propertyType, T propertyValue) {
                        return null;
                    }

                    @Override
                    public void renderURL(PropertyMap properties, MimeType mimeType, Appendable appendable) throws IOException {
                        WebRequestBridge.this.http.renderRequestURL(appendable);
                        UriBuilder writer = new UriBuilder(appendable, mimeType);
                        match.render(writer);
                        HashSet<String> matched = match.getMatched().isEmpty() ? Collections.emptySet() : new HashSet<String>(match.getMatched().size());
                        for (PathParam param : match.getMatched().keySet()) {
                            matched.add(param.getName());
                        }
                        for (ResponseParameter parameter : parameters.values()) {
                            if (matched.contains(parameter.getName())) continue;
                            for (int i = 0; i < parameter.size(); ++i) {
                                writer.appendQueryParameter(parameter.getEncoding(), parameter.getName(), (String)parameter.get(i));
                            }
                        }
                    }
                };
            }
            throw new IllegalArgumentException("The parameters " + parameters + " are not valid");
        }
        throw new UnsupportedOperationException("handle me gracefully method not mapped " + handler.getHandle());
    }

    @Override
    public void setResponse(Response response) throws IllegalArgumentException, IOException {
        this.response = response;
    }

    @Override
    public final void begin(Request request) {
        this.request = request;
    }

    @Override
    public void end() {
        this.request = null;
    }

    @Override
    public void execute(Runnable runnable) throws RejectedExecutionException {
        this.http.execute(runnable);
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invoke() throws Exception {
        try {
            this.bridge.getApplication().resolveBean(ControllerService.class).invoke(this);
        }
        finally {
            Tools.safeClose(this);
        }
    }

    boolean send() throws Exception {
        if (this.response instanceof Response.Error) {
            Response.Error error = (Response.Error)this.response;
            this.http.getRequestContext().send(error, this.bridge.getRunMode().getPrettyFail());
            return true;
        }
        if (this.response instanceof Response.View) {
            Response.View view = (Response.View)this.response;
            Phase.View.Dispatch update = (Phase.View.Dispatch)view;
            Boolean redirect = view.getProperties().getValue(PropertyType.REDIRECT_AFTER_ACTION);
            if (redirect != null && !redirect.booleanValue()) {
                ControllerHandler desc = this.bridge.getApplication().resolveBean(ControllerService.class).getDescriptor().getMethodByHandle(update.getTarget());
                Map<String, RequestParameter> rp = Collections.emptyMap();
                for (ResponseParameter parameter : update.getParameters().values()) {
                    if (rp.isEmpty()) {
                        rp = new HashMap();
                    }
                    RequestParameter requestParameter = RequestParameter.create(parameter.getName(), parameter.toArray());
                    rp.put(requestParameter.getName(), requestParameter);
                }
                WebViewBridge requestBridge = new WebViewBridge(this.bridge, this.handler, this.http, desc, rp);
                requestBridge.invoke();
                return requestBridge.send();
            }
            String url = update.with(MimeType.PLAIN).with(update.getProperties()).toString();
            Iterable<Map.Entry<String, Object>> headers = view.getProperties().getValues(PropertyType.HEADER);
            if (headers == null) {
                headers = Tools.emptyIterable();
            }
            this.http.getRequestContext().setHeaders(headers);
            this.http.getRequestContext().sendRedirect(url);
            return true;
        }
        if (this.response instanceof Response.Redirect) {
            Response.Redirect redirect = (Response.Redirect)this.response;
            String url = redirect.getLocation();
            this.http.getRequestContext().sendRedirect(url);
            return true;
        }
        return false;
    }

    @Override
    public void renderAssetURL(AssetLocation location, String uri, Appendable appendable) throws NullPointerException, UnsupportedOperationException, IOException {
        this.http.getRequestContext().renderAssetURL(location, uri, appendable);
    }
}

