/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import juzu.impl.common.Logger;
import juzu.impl.common.Tools;
import juzu.impl.compiler.Message;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;

public abstract class BaseProcessor
extends AbstractProcessor {
    private static final String lineSep = System.getProperty("line.separator");
    private static final ThreadLocal<Formatter> currentLog = new ThreadLocal();
    private static final Map<String, Logger> loggers = new HashMap<String, Logger>();
    private static final Logger logger = BaseProcessor.getLogger(BaseProcessor.class);
    private boolean formalErrorReporting = false;
    private ProcessingContext context;

    public static Logger getLogger(Class<?> type) {
        String key = type.getName();
        final String name = type.getSimpleName();
        Logger logger = loggers.get(key);
        if (logger == null) {
            logger = new Logger(){

                @Override
                protected void send(Level level, CharSequence msg, Throwable t) {
                    BaseProcessor.log(name, level, msg, t);
                }
            };
            loggers.put(key, logger);
        }
        return logger;
    }

    private static void log(String name, Level level, CharSequence msg, Throwable t) {
        Formatter sb = currentLog.get();
        if (sb != null) {
            sb.format("%1$tH:%1$tM,%1$tS:%1$tL %2$-7s [%3$s]: %4$s", System.currentTimeMillis(), level.getName(), name, msg);
            sb.format(lineSep, new Object[0]);
            if (t != null) {
                StringWriter buffer = new StringWriter();
                t.printStackTrace(new PrintWriter(buffer));
                sb.format("%1$s", buffer);
            }
        }
    }

    protected BaseProcessor() {
    }

    public final boolean getFormalErrorReporting() {
        return this.formalErrorReporting;
    }

    public final ProcessingContext getContext() {
        return this.context;
    }

    @Override
    public final Set<String> getSupportedOptions() {
        Set<String> options = super.getSupportedOptions();
        HashSet<String> our = new HashSet<String>(options);
        our.add("juzu.error_reporting");
        return our;
    }

    @Override
    public final void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        currentLog.set(new Formatter());
        this.formalErrorReporting = "formal".equalsIgnoreCase(processingEnv.getOptions().get("juzu.error_reporting"));
        this.context = new ProcessingContext(processingEnv);
        this.doInit(this.context);
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_6;
    }

    protected void doInit(ProcessingContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        block40: {
            try {
                this.doProcess(annotations, roundEnv);
            }
            catch (Exception e) {
                if (e instanceof ProcessingException) {
                    ProcessingException ce = (ProcessingException)e;
                    Element element = ce.getElement();
                    AnnotationMirror annotation = ce.getAnnotation();
                    StringBuilder msg = new StringBuilder();
                    for (Message cm : ce) {
                        msg.setLength(0);
                        MessageCode code = cm.getCode();
                        Object[] args = cm.getArguments();
                        if (this.formalErrorReporting) {
                            cm.format(msg, true);
                        } else {
                            try {
                                new Formatter(msg).format(Locale.getDefault(), code.getMessage(), args).flush();
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                System.out.println("---------------------------------------");
                                System.out.println(code.getMessage());
                                System.out.println(Arrays.toString(args));
                                e.printStackTrace();
                                System.out.println("---------------------------------------");
                            }
                        }
                        StringWriter writer = new StringWriter();
                        if (element == null) {
                            writer.append("Compilation error: ");
                        } else if (annotation == null) {
                            writer.append("Compilation error for element ").append(element.toString()).append(": ");
                        } else {
                            writer.append("Compilation error for element ").append(element.toString()).append(" at annotation ").append(annotation.toString()).append(": ");
                        }
                        writer.append(msg).append("\n");
                        e.printStackTrace(new PrintWriter(writer));
                        logger.info(writer.getBuffer());
                        this.context.report(Diagnostic.Kind.ERROR, msg, element, annotation, null);
                    }
                    break block40;
                }
                String msg = e.getMessage() == null ? "Exception : " + e.getClass().getName() : e.getMessage();
                StringWriter writer = new StringWriter();
                writer.append("Compilation error: ");
                writer.append(msg).append("\n");
                e.printStackTrace(new PrintWriter(writer));
                logger.info(writer.getBuffer());
                this.context.report(Diagnostic.Kind.ERROR, msg, null, null, null);
            }
            finally {
                block41: {
                    if (!roundEnv.processingOver()) break block41;
                    String t = currentLog.get().toString();
                    currentLog.set(new Formatter());
                    if (t.length() <= 0) break block41;
                    String s = null;
                    InputStream in = null;
                    try {
                        FileObject file = this.context.getResource((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "juzu", (CharSequence)"processor.log");
                        in = file.openInputStream();
                        s = Tools.read(in, Tools.UTF_8);
                    }
                    catch (Exception ignore) {
                        Tools.safeClose(in);
                        catch (Throwable throwable) {
                            Tools.safeClose(in);
                            throw throwable;
                        }
                    }
                    Tools.safeClose(in);
                    OutputStream out = null;
                    try {
                        FileObject file = this.context.createResource((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "juzu", (CharSequence)"processor.log", new Element[0]);
                        out = file.openOutputStream();
                        if (s != null) {
                            out.write(s.getBytes(Tools.UTF_8));
                        }
                        out.write(t.getBytes(Tools.UTF_8));
                    }
                    catch (Exception ignore) {
                        Tools.safeClose(out);
                        catch (Throwable throwable) {
                            Tools.safeClose(out);
                            throw throwable;
                        }
                    }
                    Tools.safeClose(out);
                }
            }
        }
        return false;
    }

    protected abstract void doProcess(Set<? extends TypeElement> var1, RoundEnvironment var2) throws ProcessingException;
}

