/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template.metamodel;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import juzu.impl.common.FileKey;
import juzu.impl.common.Logger;
import juzu.impl.common.Path;
import juzu.impl.common.Tools;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.plugin.template.metamodel.AbstractContainerMetaModel;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;
import juzu.impl.template.spi.EmitContext;
import juzu.impl.template.spi.TemplateProvider;
import juzu.template.TagHandler;

abstract class AbstractEmitter
implements Serializable {
    private static final Logger log = BaseProcessor.getLogger(AbstractEmitter.class);
    final AbstractContainerMetaModel owner;
    private Set<Path.Absolute> emitted;
    private Map<Path.Absolute, FileObject> classCache;

    AbstractEmitter(AbstractContainerMetaModel owner) {
        this.owner = owner;
        this.emitted = new HashSet<Path.Absolute>();
        this.classCache = new HashMap<Path.Absolute, FileObject>();
    }

    void prePassivate() {
        log.info("Evicting cache " + this.emitted);
        this.emitted.clear();
        this.classCache.clear();
    }

    void emit(TemplateMetaModel template, Element[] elements) {
        TemplateProvider<?> provider = this.owner.resolveTemplateProvider(template.getPath().getExt());
        this.resolvedQualified(provider, template, elements);
        this.emitScript(template, provider, elements);
    }

    private void emitScript(final TemplateMetaModel template, final TemplateProvider provider, final Element[] elements) {
        this.owner.application.getProcessingContext().executeWithin(elements[0], new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path.Absolute path = template.getPath();
                if (!AbstractEmitter.this.emitted.contains(path)) {
                    try {
                        EmitContext emitCtx = new EmitContext(){

                            @Override
                            public TagHandler resolveTagHandler(String name) {
                                return AbstractEmitter.this.owner.resolveTagHandler(name);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void createResource(Path.Absolute path, CharSequence content) throws IOException {
                                FileKey key = FileKey.newName(path);
                                FileObject scriptFile = AbstractEmitter.this.owner.application.getProcessingContext().createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, key, elements);
                                Writer writer = null;
                                try {
                                    writer = scriptFile.openWriter();
                                    writer.append(content);
                                    log.info("Generated template script " + path.getCanonical() + " as " + scriptFile.toUri() + " with originating elements " + Arrays.asList(elements));
                                }
                                finally {
                                    Tools.safeClose(writer);
                                }
                            }
                        };
                        provider.emit(emitCtx, template.templateModel);
                        AbstractEmitter.this.emitted.add(path);
                    }
                    catch (Exception e) {
                        throw TemplateMetaModel.CANNOT_WRITE_TEMPLATE_SCRIPT.failure(e, template.getPath());
                    }
                } else {
                    log.info("Template " + template.getPath() + " was found in cache");
                }
                return null;
            }
        });
    }

    protected abstract void emitClass(TemplateProvider<?> var1, TemplateMetaModel var2, Element[] var3, Writer var4) throws IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resolvedQualified(TemplateProvider<?> provider, TemplateMetaModel template, Element[] elements) {
        Path.Absolute path = template.getPath();
        if (this.classCache.containsKey(path)) {
            log.info("Template class " + path + " was found in cache");
            return;
        }
        Path.Absolute resolvedPath = this.owner.resolvePath(path);
        Writer writer = null;
        try {
            JavaFileObject classFile = this.owner.application.getProcessingContext().createSourceFile(resolvedPath.getName(), elements);
            writer = classFile.openWriter();
            this.emitClass(provider, template, elements, writer);
            this.classCache.put(path, classFile);
            log.info("Generated template class " + path + " as " + classFile.toUri() + " with originating elements " + Arrays.asList(elements));
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                throw TemplateMetaModel.CANNOT_WRITE_TEMPLATE_CLASS.failure(e, elements[0], path);
            }
            catch (Throwable throwable) {
                Tools.safeClose(writer);
                throw throwable;
            }
        }
        Tools.safeClose(writer);
    }
}

