/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.authz;

import java.lang.reflect.Method;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import juzu.Response;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.impl.request.Stage;
import juzu.request.SecurityContext;

public class AuthzManager
implements RequestFilter<Stage.Handler> {
    public Class<Stage.Handler> getStageType() {
        return Stage.Handler.class;
    }

    public Response handle(Stage.Handler argument) {
        Request request = argument.getRequest();
        Method method = request.getHandler().getMethod();
        RolesAllowed rolesAllowed = method.getAnnotation(RolesAllowed.class);
        PermitAll permitAll = method.getAnnotation(PermitAll.class);
        DenyAll denyAll = method.getAnnotation(DenyAll.class);
        if (rolesAllowed == null && permitAll == null && denyAll == null) {
            Class<?> controllerClass = method.getDeclaringClass();
            rolesAllowed = controllerClass.getAnnotation(RolesAllowed.class);
            denyAll = controllerClass.getAnnotation(DenyAll.class);
        }
        boolean ok = false;
        if (denyAll != null) {
            ok = false;
        } else if (rolesAllowed != null) {
            SecurityContext securityContext = request.getSecurityContext();
            for (String role : rolesAllowed.value()) {
                if (!securityContext.isUserInRole(role)) continue;
                ok = true;
                break;
            }
        } else {
            ok = true;
        }
        if (!ok) {
            return new Response.Error.Forbidden("Access denied");
        }
        return argument.invoke();
    }
}

