/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import java.io.IOException;
import java.util.Map;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.EntityUnmarshaller;
import juzu.plugin.jackson.Jackson;
import juzu.request.ClientContext;
import juzu.request.RequestParameter;

public class JacksonUnmarshaller
extends EntityUnmarshaller {
    public boolean accept(String mediaType) {
        return mediaType.equals("application/json");
    }

    public void unmarshall(String mediaType, ClientContext context, Iterable<Map.Entry<ContextualParameter, Object>> contextualArguments, Map<String, RequestParameter> parameterArguments) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode tree = mapper.readTree(context.getInputStream());
        for (Map.Entry<ContextualParameter, Object> contextualArgument : contextualArguments) {
            Class type = contextualArgument.getKey().getType();
            if (JsonNode.class.isAssignableFrom(type)) {
                contextualArgument.setValue(tree);
                continue;
            }
            if (contextualArgument.getKey().getAnnotations().getAnnotation(Jackson.class) == null) continue;
            Object value = mapper.readValue((JsonParser)new TreeTraversingParser(tree), type);
            contextualArgument.setValue(value);
        }
    }
}

