/*
 * Decompiled with CFR 0.152.
 */
package juzu.templating.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.DefaultMustacheVisitor;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheVisitor;
import com.github.mustachejava.TemplateContext;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import juzu.impl.template.spi.TemplateStub;
import juzu.io.Stream;
import juzu.template.TemplateExecutionException;
import juzu.template.TemplateRenderContext;
import juzu.templating.mustache.ContextMap;

public class TemplateStubImpl
extends TemplateStub {
    private Mustache mustache;
    private final String resourceRoot;
    private final String mustacheName;

    public TemplateStubImpl(String id) {
        super(id);
        int index = id.lastIndexOf(46);
        String resourceRoot = id.substring(0, index).replace('.', '/') + "/";
        String name = id.substring(index + 1) + ".mustache";
        this.resourceRoot = resourceRoot;
        this.mustacheName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInit(ClassLoader loader) {
        ClassLoader previous = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            DefaultMustacheFactory factory = new DefaultMustacheFactory(this.resourceRoot){

                public MustacheVisitor createMustacheVisitor() {
                    return new DefaultMustacheVisitor(this){

                        public void pragma(TemplateContext templateContext, String pragma, String args) {
                            if (!"param".equals(pragma)) {
                                super.pragma(templateContext, pragma, args);
                            }
                        }
                    };
                }
            };
            this.mustache = factory.compile(this.mustacheName);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previous);
        }
    }

    protected void doRender(TemplateRenderContext renderContext) throws TemplateExecutionException, IOException {
        StringWriter buffer = new StringWriter();
        this.mustache.execute((Writer)buffer, new Object[]{new ContextMap(renderContext)});
        Stream stream = renderContext.getPrinter();
        stream.append((CharSequence)buffer.getBuffer());
    }
}

