/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge;

import java.util.HashMap;
import java.util.Map;
import juzu.io.Encoding;
import juzu.request.ResponseParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters
extends HashMap<String, ResponseParameter> {
    public void setParameter(String name, String value) throws NullPointerException {
        this.setParameter(Encoding.RFC3986, name, value);
    }

    public void setParameter(Encoding encoding, String name, String value) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("No null name can be used");
        }
        if (name.startsWith("juzu.")) {
            throw new IllegalArgumentException("Parameter name cannot be prefixed with juzu.");
        }
        if (value != null) {
            this.put(name, ResponseParameter.create(encoding, name, value));
        } else {
            this.remove(name);
        }
    }

    public void setParameter(Encoding encoding, String name, String[] value) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("No null name can be used");
        }
        if (value == null) {
            throw new NullPointerException("No null value can be used");
        }
        if (name.startsWith("juzu.")) {
            throw new IllegalArgumentException("Parameter name cannot be prefixed with juzu.");
        }
        if (value.length == 0) {
            this.remove(name);
        } else {
            for (String component : value) {
                if (component != null) continue;
                throw new IllegalArgumentException("Argument array cannot contain null value");
            }
            this.put(name, ResponseParameter.create(encoding, name, (String[])value.clone()));
        }
    }

    public void setParameter(String name, String[] value) throws NullPointerException, IllegalArgumentException {
        this.setParameter(Encoding.RFC3986, name, value);
    }

    public void setParameters(Encoding encoding, Map<String, String[]> parameters) throws NullPointerException, IllegalArgumentException {
        throw new UnsupportedOperationException("todo");
    }

    public void setParameters(Map<String, String[]> parameters) throws NullPointerException, IllegalArgumentException {
        if (parameters == null) {
            throw new NullPointerException("No null parameters accepted");
        }
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalArgumentException("No null parameter key can be null");
            }
            if (entry.getValue() == null) {
                throw new IllegalArgumentException("No null parameter value can be null");
            }
            this.setParameter(entry.getKey(), entry.getValue());
        }
    }
}

