/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Provider;
import javax.inject.Qualifier;
import juzu.Scope;
import juzu.impl.inject.spi.Injector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanDescriptor {
    private final Class<?> declaredType;
    private final Scope scope;
    private final List<Annotation> qualifiers;
    private final Class<?> implementationType;

    private BeanDescriptor(Class<?> declaredType, Scope scope, List<Annotation> qualifiers, Class<?> implementationType) throws NullPointerException, IllegalArgumentException {
        if (declaredType == null) {
            throw new NullPointerException("No null declared type accepted");
        }
        if (qualifiers != null) {
            for (Annotation qualifier : qualifiers) {
                if (qualifier.annotationType().getAnnotation(Qualifier.class) != null) continue;
                throw new IllegalArgumentException("Qualifier annotation " + qualifier + " is not annotated with @Qualifier");
            }
        }
        this.declaredType = declaredType;
        this.scope = scope;
        this.qualifiers = qualifiers;
        this.implementationType = implementationType;
    }

    public static <T> BeanDescriptor createFromProviderType(final Class<T> declaredType, Scope scope, List<Annotation> qualifiers, final Class<? extends Provider<T>> implementationType) throws NullPointerException, IllegalArgumentException {
        return new BeanDescriptor(declaredType, scope, qualifiers, implementationType){

            public void bind(Injector builder) {
                builder.declareProvider(declaredType, this.getScope(), BeanDescriptor.determineQualifiers(this.getQualifiers(), implementationType), implementationType);
            }
        };
    }

    public static <T> BeanDescriptor createFromProvider(final Class<T> declaredType, Scope scope, List<Annotation> qualifiers, final Provider<? extends T> implementationType) throws NullPointerException, IllegalArgumentException {
        return new BeanDescriptor(declaredType, scope, qualifiers, null){

            public void bind(Injector builder) {
                builder.bindProvider(declaredType, this.getScope(), BeanDescriptor.determineQualifiers(this.getQualifiers(), implementationType.getClass()), implementationType);
            }
        };
    }

    public static <T> BeanDescriptor createFromImpl(final Class<T> declaredType, Scope scope, List<Annotation> qualifiers, final Class<? extends T> implementationType) throws NullPointerException, IllegalArgumentException {
        return new BeanDescriptor(declaredType, scope, qualifiers, implementationType){

            public void bind(Injector builder) {
                builder.declareBean(declaredType, this.getScope(), this.getQualifiers(), implementationType);
            }
        };
    }

    public static <T> BeanDescriptor createFromBean(final Class<T> declaredType, Scope scope, List<Annotation> qualifiers) throws NullPointerException, IllegalArgumentException {
        return new BeanDescriptor(declaredType, scope, qualifiers, null){

            public void bind(Injector builder) {
                builder.declareBean(declaredType, this.getScope(), this.getQualifiers(), null);
            }
        };
    }

    public Class<?> getDeclaredType() {
        return this.declaredType;
    }

    public Scope getScope() {
        return this.scope;
    }

    public List<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<?> getImplementationType() {
        return this.implementationType;
    }

    public abstract void bind(Injector var1);

    private static Collection<Annotation> determineQualifiers(Collection<Annotation> qualifiers, Class<?> implementation) {
        ArrayList<Annotation> overridenQualifiers = null;
        try {
            Method get = implementation.getMethod("get", new Class[0]);
            for (Annotation annotation : get.getAnnotations()) {
                if (annotation.annotationType().getAnnotation(Qualifier.class) == null) continue;
                if (overridenQualifiers == null) {
                    overridenQualifiers = new ArrayList<Annotation>();
                }
                overridenQualifiers.add(annotation);
            }
        }
        catch (NoSuchMethodException e) {
            throw new UndeclaredThrowableException(e);
        }
        if (overridenQualifiers != null) {
            qualifiers = overridenQualifiers;
        }
        return qualifiers;
    }
}

