/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.cdi.weld;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import juzu.impl.common.Filter;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.cdi.CDIContext;
import juzu.impl.inject.spi.cdi.CDIInjector;
import juzu.impl.inject.spi.cdi.weld.WeldContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldInjector
extends CDIInjector {
    private ClassLoader classLoader;
    private List<ReadFileSystem<?>> fileSystems;

    public WeldInjector() {
        this.classLoader = null;
        this.fileSystems = new ArrayList();
    }

    public WeldInjector(WeldInjector that) {
        super(that);
        this.classLoader = that.classLoader;
        this.fileSystems = new ArrayList(that.fileSystems);
    }

    @Override
    public <P> Injector addFileSystem(ReadFileSystem<P> fs) {
        this.fileSystems.add(fs);
        return this;
    }

    @Override
    public Injector setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InjectionContext<?, ?> create(Filter<Class<?>> filter) throws Exception {
        final WeldContainer container = new WeldContainer(this.classLoader, this.scopeController, this.scopes);
        for (ReadFileSystem<?> fs : this.fileSystems) {
            container.addFileSystem(fs);
        }
        CDIContext cdiContext = new CDIContext(this, filter){

            public ClassLoader getClassLoader() {
                return container.getClassLoader();
            }

            protected BeanManager getBeanManager() {
                return container.getManager();
            }

            public void close() {
                container.stop();
            }
        };
        CDIContext.boot.set(cdiContext);
        try {
            container.start();
            Object var6_5 = null;
            CDIContext.boot.set(cdiContext);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            CDIContext.boot.set(cdiContext);
            throw throwable;
        }
        return cdiContext;
    }

    @Override
    public Injector get() {
        return new WeldInjector(this);
    }
}

