/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementHandle<E extends Element>
implements Serializable {
    public static ElementHandle<?> create(Element elt) {
        ElementKind kind = elt.getKind();
        switch (kind) {
            case FIELD: {
                VariableElement variableElt = (VariableElement)elt;
                return Field.create(variableElt);
            }
            case CLASS: {
                TypeElement typeElt = (TypeElement)elt;
                return Class.create(typeElt);
            }
            case PACKAGE: {
                PackageElement packageElt = (PackageElement)elt;
                return Package.create(packageElt);
            }
            case METHOD: {
                ExecutableElement packageElt = (ExecutableElement)elt;
                return Method.create(packageElt);
            }
        }
        throw new UnsupportedOperationException("Element " + elt + " with kind " + (Object)((Object)kind) + " not supported");
    }

    public final E get(ProcessingEnvironment env) {
        try {
            return this.doGet(env);
        }
        catch (RuntimeException e) {
            if (e.getClass().getName().equals("org.eclipse.jdt.internal.compiler.problem.AbortCompilation")) {
                return null;
            }
            throw e;
        }
    }

    protected abstract E doGet(ProcessingEnvironment var1);

    public abstract Name getPackage();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Field
    extends ElementHandle<VariableElement> {
        private final Name fqn;
        private final String name;

        public static Field create(VariableElement elt) {
            TypeElement typeElt = (TypeElement)elt.getEnclosingElement();
            String name = elt.getSimpleName().toString();
            Name fqn = Name.parse(typeElt.getQualifiedName().toString());
            return new Field(fqn, name);
        }

        public static Field create(String fqn, String name) {
            return new Field(Name.parse(fqn), name);
        }

        public static Field create(Name fqn, String name) {
            return new Field(fqn, name);
        }

        private Field(Name fqn, String name) {
            this.fqn = fqn;
            this.name = name;
        }

        public Name getFQN() {
            return this.fqn;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public Name getPackage() {
            return this.fqn.getParent();
        }

        @Override
        protected VariableElement doGet(ProcessingEnvironment env) {
            TypeElement typeElt = env.getElementUtils().getTypeElement(this.fqn);
            if (typeElt != null) {
                for (VariableElement variableElt : ElementFilter.fieldsIn(typeElt.getEnclosedElements())) {
                    if (!variableElt.getSimpleName().contentEquals(this.name)) continue;
                    return variableElt;
                }
            }
            return null;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Field) {
                Field that = (Field)obj;
                return this.fqn.equals(that.fqn) && this.name.equals(that.name);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.fqn.hashCode() ^ this.name.hashCode();
        }

        @Override
        public String toString() {
            return "ElementHandle.Field[fqn=" + this.fqn + ",name=" + this.name + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Method
    extends ElementHandle<ExecutableElement> {
        private final Name fqn;
        private final String name;
        private final ArrayList<String> parameterTypes;

        public static Method create(String type, String name, String ... parameterTypes) {
            ArrayList<String> tmp = new ArrayList<String>(parameterTypes.length);
            Collections.addAll(tmp, parameterTypes);
            return new Method(Name.parse(type), name, tmp);
        }

        public static Method create(java.lang.Class<?> type, String name, java.lang.Class<?> ... parameterTypes) {
            String[] tmp = new String[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                tmp[i] = parameterTypes[i].getName();
            }
            return Method.create(type.getName(), name, tmp);
        }

        public static Method create(Name fqn, String name, Collection<String> parameterTypes) {
            return new Method(fqn, name, new ArrayList<String>(parameterTypes));
        }

        public static Method create(ExecutableElement elt) {
            TypeElement typeElt = (TypeElement)elt.getEnclosingElement();
            String name = elt.getSimpleName().toString();
            Name fqn = Name.parse(typeElt.getQualifiedName().toString());
            ArrayList<String> parameterTypes = new ArrayList<String>();
            for (TypeMirror typeMirror : ((ExecutableType)elt.asType()).getParameterTypes()) {
                parameterTypes.add(typeMirror.toString());
            }
            return new Method(fqn, name, parameterTypes);
        }

        private Method(Name fqn, String name, ArrayList<String> parameterTypes) {
            this.fqn = fqn;
            this.name = name;
            this.parameterTypes = parameterTypes;
        }

        public Name getFQN() {
            return this.fqn;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public Name getPackage() {
            return this.fqn.getParent();
        }

        @Override
        protected ExecutableElement doGet(ProcessingEnvironment env) {
            TypeElement typeElt = env.getElementUtils().getTypeElement(this.fqn);
            if (typeElt != null) {
                block0: for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
                    List<? extends TypeMirror> parameterTypes;
                    int len;
                    if (!executableElement.getSimpleName().toString().equals(this.name) || (len = (parameterTypes = ((ExecutableType)executableElement.asType()).getParameterTypes()).size()) != this.parameterTypes.size()) continue;
                    for (int i = 0; i < len; ++i) {
                        if (!parameterTypes.get(i).toString().equals(this.parameterTypes.get(i))) continue block0;
                    }
                    return executableElement;
                }
            }
            return null;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Method) {
                Method that = (Method)obj;
                return this.fqn.equals(that.fqn) && this.name.equals(that.name) && this.parameterTypes.equals(that.parameterTypes);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode = this.fqn.hashCode() ^ this.name.hashCode();
            for (String parameterType : this.parameterTypes) {
                hashCode = hashCode * 41 + parameterType.hashCode();
            }
            return hashCode;
        }

        public MethodHandle getMethodHandle() {
            return new MethodHandle(this.fqn.toString(), this.name, this.parameterTypes.toArray(new String[this.parameterTypes.size()]));
        }

        @Override
        public String toString() {
            return "ElementHandle.Method[fqn=" + this.fqn + ",name=" + this.name + ",parameterTypes" + this.parameterTypes + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Class
    extends ElementHandle<TypeElement> {
        private final Name fqn;

        public static Class create(Name fqn) {
            return new Class(fqn);
        }

        public static Class create(TypeElement elt) {
            return new Class(Name.parse(elt.getQualifiedName().toString()));
        }

        private Class(Name fqn) {
            this.fqn = fqn;
        }

        public Name getFQN() {
            return this.fqn;
        }

        @Override
        public Name getPackage() {
            return this.fqn.getParent();
        }

        @Override
        protected TypeElement doGet(ProcessingEnvironment env) {
            return env.getElementUtils().getTypeElement(this.fqn);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Class) {
                Class that = (Class)obj;
                return this.fqn.equals(that.fqn);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.fqn.hashCode();
        }

        @Override
        public String toString() {
            return "ElementHandle.Class[fqn=" + this.fqn + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Package
    extends ElementHandle<PackageElement> {
        private final Name name;

        public static Package create(Name packageName) {
            return new Package(packageName);
        }

        public static Package create(PackageElement elt) {
            return new Package(Name.parse(elt.getQualifiedName()));
        }

        private Package(Name name) {
            this.name = name;
        }

        @Override
        public Name getPackage() {
            return this.name;
        }

        @Override
        protected PackageElement doGet(ProcessingEnvironment env) {
            return env.getElementUtils().getPackageElement(this.name);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Package) {
                Package that = (Package)obj;
                return this.name.equals(that.name);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public String toString() {
            return "ElementHandle.Package[qn=" + this.name + "]";
        }
    }
}

