/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderResponse;
import juzu.PropertyType;
import juzu.impl.asset.Asset;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.MimeBridge;
import juzu.impl.bridge.spi.portlet.PortletRenderBridge;
import juzu.impl.bridge.spi.portlet.PortletRequestBridge;
import juzu.impl.common.Formatting;
import juzu.impl.common.Tools;
import juzu.impl.plugin.asset.AssetPlugin;
import juzu.io.Chunk;
import juzu.io.Stream;
import juzu.request.Result;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletMimeBridge<Rq extends PortletRequest, Rs extends MimeResponse>
extends PortletRequestBridge<Rq, Rs>
implements MimeBridge {
    PortletMimeBridge(Bridge bridge, Rq request, Rs response, PortletConfig config) {
        super(bridge, request, response, config);
    }

    public abstract Stream createStream(String var1, Charset var2) throws IOException;

    @Override
    public void send() throws IOException, PortletException {
        if (this.result instanceof Result.Status) {
            Result.Status status = (Result.Status)this.result;
            final AssetPlugin assetPlugin = (AssetPlugin)this.bridge.getApplication().getPlugin("asset");
            Stream stream = new Stream(){
                private Charset charset = Tools.ISO_8859_1;
                private String mimeType = null;
                private Stream dataStream = null;
                private final LinkedList<String> stylesheetAssets = new LinkedList();
                private final LinkedList<String> scriptAssets = new LinkedList();

                public void provide(Chunk chunk) {
                    if (chunk instanceof Chunk.Property) {
                        Chunk.Property property = (Chunk.Property)chunk;
                        if (property.type == PropertyType.CHARSET) {
                            this.charset = (Charset)property.value;
                        } else if (property.type == PropertyType.MIME_TYPE) {
                            this.mimeType = (String)property.value;
                        } else if (property.type == PropertyType.HEADER) {
                            Map.Entry header = (Map.Entry)property.value;
                            for (String value : (String[])header.getValue()) {
                                ((MimeResponse)PortletMimeBridge.this.resp).addProperty((String)header.getKey(), value);
                            }
                        }
                        if (property.type == PropertyType.TITLE) {
                            if (PortletMimeBridge.this.resp instanceof RenderResponse) {
                                ((RenderResponse)PortletMimeBridge.this.resp).setTitle((String)property.value);
                            }
                        } else if (property.type == PropertyType.META_TAG) {
                            Map.Entry metaTag = (Map.Entry)property.value;
                            Element elt = ((MimeResponse)PortletMimeBridge.this.resp).createElement("meta");
                            elt.setAttribute("name", (String)metaTag.getKey());
                            elt.setAttribute("content", (String)metaTag.getValue());
                            ((MimeResponse)PortletMimeBridge.this.resp).addProperty("javax.portlet.markup.head.element", elt);
                        } else if (property.type == PropertyType.STYLESHEET) {
                            this.stylesheetAssets.add((String)property.value);
                        } else if (property.type == PropertyType.SCRIPT) {
                            this.scriptAssets.add((String)property.value);
                        } else if (property.type == PropertyType.HEADER_TAG) {
                            Element headerTag = (Element)property.value;
                            Element responseTag = ((MimeResponse)PortletMimeBridge.this.resp).createElement(headerTag.getTagName());
                            for (Node child : Tools.children(headerTag)) {
                                child = responseTag.getOwnerDocument().importNode(headerTag, true);
                                responseTag.appendChild(child);
                            }
                            ((MimeResponse)PortletMimeBridge.this.resp).addProperty("javax.portlet.markup.head.element", headerTag);
                        }
                    } else if (chunk instanceof Chunk.Data) {
                        Chunk.Data data = (Chunk.Data)chunk;
                        if (this.dataStream == null) {
                            Element elt;
                            Iterable<Asset> stylesheets = assetPlugin.getStylesheetManager().resolveAssets(this.stylesheetAssets);
                            for (Asset stylesheet : stylesheets) {
                                int pos = stylesheet.getURI().lastIndexOf(46);
                                String ext = pos == -1 ? "css" : stylesheet.getURI().substring(pos + 1);
                                elt = ((MimeResponse)PortletMimeBridge.this.resp).createElement("link");
                                elt.setAttribute("media", "screen");
                                elt.setAttribute("rel", "stylesheet");
                                elt.setAttribute("type", "text/" + ext);
                                elt.setAttribute("href", ((PortletRenderBridge)PortletMimeBridge.this).getAssetURL(stylesheet));
                                ((MimeResponse)PortletMimeBridge.this.resp).addProperty("javax.portlet.markup.head.element", elt);
                            }
                            Iterable<Asset> scripts = assetPlugin.getScriptManager().resolveAssets(this.scriptAssets);
                            for (Asset script : scripts) {
                                String url = ((PortletRenderBridge)PortletMimeBridge.this).getAssetURL(script);
                                elt = ((MimeResponse)PortletMimeBridge.this.resp).createElement("script");
                                elt.setAttribute("type", "text/javascript");
                                elt.setAttribute("src", url);
                                String dummy = PortletMimeBridge.this.bridge.getApplication().getName() + " script ";
                                Comment comment = elt.getOwnerDocument().createComment(dummy);
                                elt.appendChild(comment);
                                ((MimeResponse)PortletMimeBridge.this.resp).addProperty("javax.portlet.markup.head.element", elt);
                            }
                            try {
                                this.dataStream = PortletMimeBridge.this.createStream(this.mimeType, this.charset);
                            }
                            catch (IOException e) {
                                throw new UnsupportedOperationException("Handle me gracefully");
                            }
                        }
                        this.dataStream.provide(data);
                    }
                }

                public void close(Thread.UncaughtExceptionHandler errorHandler) {
                }
            };
            if (status.code != 200) {
                ((MimeResponse)this.resp).addProperty("portlet.http-status-code", Integer.toString(status.code));
            }
            status.streamable.send(stream);
        } else if (this.result instanceof Result.Error) {
            Result.Error error = (Result.Error)this.result;
            if (this.bridge.getRunMode().getPrettyFail()) {
                ((MimeResponse)this.resp).setContentType("text/html");
                PrintWriter writer = ((MimeResponse)this.resp).getWriter();
                writer.append("<div class=\"juzu\">");
                Throwable cause = error.cause;
                if (cause != null) {
                    Formatting.renderThrowable(null, writer, cause);
                } else {
                    writer.append(error.message);
                }
                writer.append("</div>");
                writer.close();
            } else {
                throw new PortletException(error.cause);
            }
        }
    }
}

