/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import juzu.impl.common.Filter;
import juzu.impl.inject.ScopeController;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.inject.spi.cdi.CDIInjector;
import juzu.impl.plugin.controller.AmbiguousResolutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDIContext
extends InjectionContext<Bean<?>, CreationalContext<?>> {
    public static final ThreadLocal<CDIContext> boot = new ThreadLocal();
    final CDIInjector injector;
    final ArrayList<Bean> beans = new ArrayList();
    final Filter<Class<?>> filter;

    public CDIContext(CDIInjector injector, Filter<Class<?>> filter) throws Exception {
        this.filter = filter;
        this.injector = injector;
    }

    @Override
    public ScopeController getScopeController() {
        return this.injector.scopeController;
    }

    @Override
    public InjectorProvider getProvider() {
        return InjectorProvider.CDI_WELD;
    }

    @Override
    public abstract ClassLoader getClassLoader();

    protected abstract BeanManager getBeanManager();

    @Override
    public Bean<?> resolveBean(Class<?> type) {
        BeanManager manager = this.getBeanManager();
        Set beans = manager.getBeans(type, new Annotation[0]);
        switch (beans.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Bean)beans.iterator().next();
            }
        }
        throw new AmbiguousResolutionException("Could not resolve bean of type " + type + ": " + beans);
    }

    @Override
    public Iterable<Bean<?>> resolveBeans(Class<?> type) {
        List resolved = Collections.emptyList();
        for (Bean bean : this.beans) {
            if (!type.isAssignableFrom(bean.getBeanClass())) continue;
            if (resolved.isEmpty()) {
                resolved = new ArrayList();
            }
            resolved.add(bean);
        }
        BeanManager manager = this.getBeanManager();
        return manager.getBeans(type, new Annotation[0]);
    }

    @Override
    public Bean<?> resolveBean(String name) {
        BeanManager manager = this.getBeanManager();
        Set beans = manager.getBeans(name);
        switch (beans.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Bean)beans.iterator().next();
            }
        }
        throw new AmbiguousResolutionException("Could not resolve bean of type " + name + ": " + beans);
    }

    @Override
    public CreationalContext<?> create(Bean<?> bean) {
        BeanManager manager = this.getBeanManager();
        return manager.createCreationalContext(bean);
    }

    @Override
    public void release(Bean<?> bean, CreationalContext<?> instance) {
        instance.release();
    }

    @Override
    public Object get(Bean<?> bean, CreationalContext<?> instance) throws InvocationTargetException {
        try {
            BeanManager manager = this.getBeanManager();
            return manager.getReference(bean, (Type)bean.getBeanClass(), instance);
        }
        catch (CreationException e) {
            e.printStackTrace();
            throw new InvocationTargetException(e.getCause());
        }
        catch (RuntimeException e) {
            throw new InvocationTargetException(e);
        }
    }

    @Override
    public void close() {
    }
}

