/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.asset;

import juzu.asset.AssetLocation;

public class Asset {
    private final AssetLocation location;
    private final String uri;

    public Asset(AssetLocation location, String uri) {
        this.location = location;
        this.uri = uri;
    }

    public static Asset server(String uri) {
        return Asset.of(AssetLocation.SERVER, uri);
    }

    public static Asset application(String uri) {
        return Asset.of(AssetLocation.APPLICATION, uri);
    }

    public static Asset url(String id, String uri) {
        return Asset.of(AssetLocation.URL, uri);
    }

    public static Asset of(AssetLocation location, String uri) {
        return new Asset(location, uri);
    }

    public AssetLocation getLocation() {
        return this.location;
    }

    public String getURI() {
        return this.uri;
    }
}

