/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router.regex;

import java.io.IOException;
import juzu.impl.router.regex.Literal;
import juzu.impl.router.regex.RENode;
import juzu.impl.router.regex.REVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RERenderer
extends REVisitor<IOException> {
    private final Appendable appendable;

    public static <A extends Appendable> A render(RENode re, A appendable) throws IOException, NullPointerException {
        if (re == null) {
            throw new NullPointerException("No null disjunction accepted");
        }
        if (appendable == null) {
            throw new NullPointerException("No null appendable accepted");
        }
        RERenderer renderer = new RERenderer(appendable);
        re.accept(renderer);
        return appendable;
    }

    public RERenderer(Appendable appendable) {
        this.appendable = appendable;
    }

    @Override
    protected void visit(RENode.Disjunction disjunction) throws IOException, NullPointerException {
        RENode.Disjunction next;
        RENode.Alternative alternative = disjunction.getAlternative();
        if (alternative != null) {
            alternative.accept(this);
        }
        if (disjunction.hasAlternative() && disjunction.hasNext()) {
            this.appendable.append('|');
        }
        if ((next = disjunction.getNext()) != null) {
            next.accept(this);
        }
    }

    @Override
    protected void visit(RENode.Alternative alternative) throws IOException, NullPointerException {
        alternative.getExpr().accept(this);
        RENode.Alternative next = alternative.getNext();
        if (next != null) {
            this.visit(next);
        }
    }

    @Override
    protected void visit(RENode.Assertion.Begin expr) throws IOException {
        this.appendable.append('^');
        if (expr.getQuantifier() != null) {
            expr.getQuantifier().toString(this.appendable);
        }
    }

    @Override
    protected void visit(RENode.Assertion.End expr) throws IOException {
        this.appendable.append('$');
        if (expr.getQuantifier() != null) {
            expr.getQuantifier().toString(this.appendable);
        }
    }

    @Override
    protected void visit(RENode.Group expr) throws IOException {
        this.appendable.append(expr.getType().getOpen());
        this.visit(expr.getDisjunction());
        this.appendable.append(expr.getType().getClose());
        if (expr.getQuantifier() != null) {
            expr.getQuantifier().toString(this.appendable);
        }
    }

    @Override
    protected void visit(RENode.Char expr) throws IOException {
        Literal.escapeTo(expr.getValue(), this.appendable);
        if (expr.getQuantifier() != null) {
            expr.getQuantifier().toString(this.appendable);
        }
    }

    @Override
    protected void visit(RENode.Any expr) throws IOException {
        this.appendable.append('.');
        if (expr.getQuantifier() != null) {
            expr.getQuantifier().toString(this.appendable);
        }
    }

    @Override
    protected void visit(RENode.CharacterClass expr) throws IOException {
        this.appendable.append("[");
        expr.getExpr().accept(this);
        this.appendable.append("]");
        if (expr.getQuantifier() != null) {
            expr.getQuantifier().toString(this.appendable);
        }
    }

    @Override
    protected void visit(RENode.CharacterClassExpr.Not expr) throws IOException {
        boolean needBrace = false;
        for (RENode current = expr.getParent(); current != null; current = current.getParent()) {
            if (current instanceof RENode.CharacterClassExpr.Or) {
                needBrace = true;
                break;
            }
            if (current instanceof RENode.CharacterClassExpr.And) {
                needBrace = true;
                break;
            }
            if (!(current instanceof RENode.CharacterClassExpr.Not)) continue;
            needBrace = true;
            break;
        }
        if (needBrace) {
            this.appendable.append("[");
        }
        this.appendable.append("^");
        expr.getNegated().accept(this);
        if (needBrace) {
            this.appendable.append(']');
        }
    }

    @Override
    protected void visit(RENode.CharacterClassExpr.Or expr) throws IOException {
        expr.getLeft().accept(this);
        expr.getRight().accept(this);
    }

    @Override
    protected void visit(RENode.CharacterClassExpr.And expr) throws IOException {
        expr.getLeft().accept(this);
        this.appendable.append("&&");
        expr.getRight().accept(this);
    }

    @Override
    protected void visit(RENode.CharacterClassExpr.Range expr) throws IOException {
        this.visit(expr.getFrom());
        this.appendable.append('-');
        this.visit(expr.getTo());
    }

    @Override
    protected void visit(RENode.CharacterClassExpr.Char expr) throws IOException {
        Literal.escapeTo(expr.getValue(), this.appendable);
    }
}

